/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BEROctetString
extends ASN1OctetString {
    private static final int DEFAULT_CHUNK_SIZE = 1000;
    private final int chunkSize;
    private final ASN1OctetString[] octs;

    private static byte[] toBytes(ASN1OctetString[] aSN1OctetStringArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i != aSN1OctetStringArray.length; ++i) {
            try {
                DEROctetString dEROctetString = (DEROctetString)aSN1OctetStringArray[i];
                byteArrayOutputStream.write(dEROctetString.getOctets());
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(aSN1OctetStringArray[i].getClass().getName() + " found in input should only contain DEROctetString");
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("exception converting octets " + iOException.toString());
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public BEROctetString(byte[] byArray) {
        this(byArray, 1000);
    }

    public BEROctetString(ASN1OctetString[] aSN1OctetStringArray) {
        this(aSN1OctetStringArray, 1000);
    }

    public BEROctetString(byte[] byArray, int n) {
        this(byArray, null, n);
    }

    public BEROctetString(ASN1OctetString[] aSN1OctetStringArray, int n) {
        this(BEROctetString.toBytes(aSN1OctetStringArray), aSN1OctetStringArray, n);
    }

    private BEROctetString(byte[] byArray, ASN1OctetString[] aSN1OctetStringArray, int n) {
        super(byArray);
        this.octs = aSN1OctetStringArray;
        this.chunkSize = n;
    }

    public Enumeration getObjects() {
        if (this.octs == null) {
            return this.generateOcts().elements();
        }
        return new Enumeration(){
            int counter = 0;

            public boolean hasMoreElements() {
                return this.counter < BEROctetString.this.octs.length;
            }

            public Object nextElement() {
                return BEROctetString.this.octs[this.counter++];
            }
        };
    }

    private Vector generateOcts() {
        Vector<DEROctetString> vector = new Vector<DEROctetString>();
        for (int i = 0; i < this.string.length; i += this.chunkSize) {
            int n = Math.min(this.string.length, i + this.chunkSize);
            byte[] byArray = new byte[n - i];
            System.arraycopy(this.string, i, byArray, 0, byArray.length);
            vector.addElement(new DEROctetString(byArray));
        }
        return vector;
    }

    boolean isConstructed() {
        return true;
    }

    int encodedLength() throws IOException {
        int n = 0;
        Enumeration enumeration = this.getObjects();
        while (enumeration.hasMoreElements()) {
            n += ((ASN1Encodable)enumeration.nextElement()).toASN1Primitive().encodedLength();
        }
        return 2 + n + 2;
    }

    public void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        aSN1OutputStream.writeObject(this);
    }

    void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodedIndef(bl, 36, this.getObjects());
    }

    static BEROctetString fromSequence(ASN1Sequence aSN1Sequence) {
        int n = aSN1Sequence.size();
        ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[n];
        for (int i = 0; i < n; ++i) {
            aSN1OctetStringArray[i] = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(i));
        }
        return new BEROctetString(aSN1OctetStringArray);
    }
}

