/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.stores;

import org.apache.commons.javaflow.bytecode.transformation.ResourceTransformer;
import org.apache.commons.jci.stores.ResourceStore;

public class TransformingResourceStore
implements ResourceStore {
    private final ResourceStore store;
    private final ResourceTransformer[] transformers;

    public TransformingResourceStore(ResourceStore pStore, ResourceTransformer[] pTransformers) {
        this.store = pStore;
        this.transformers = pTransformers;
    }

    public byte[] read(String resourceName) {
        return this.store.read(resourceName);
    }

    public void remove(String resourceName) {
        this.store.remove(resourceName);
    }

    public void write(String resourceName, byte[] resourceData) {
        byte[] out = resourceData;
        byte[] in = resourceData;
        for (ResourceTransformer transformer : this.transformers) {
            in = out = transformer.transform(in);
        }
        this.store.write(resourceName, out);
    }

    public String toString() {
        return this.store.toString();
    }
}

