/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.mockWebServices;

import fitlibrary.log.FixturingLogger;
import fitlibrary.mockWebServices.MockWebServiceHandler;
import fitlibrary.mockWebServices.logger.MockLogger;
import fitlibrary.mockWebServices.term.OrTerm;
import fitlibrary.mockWebServices.term.Term;
import fitlibrary.server.HttpServer;
import java.io.IOException;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.log4j.Logger;

public class MockingServer
extends HttpServer {
    static Logger logger = FixturingLogger.getLogger(MockingServer.class);
    protected final OrTerm term = new OrTerm(new Term[0]);
    private MockLogger logging;

    public MockingServer(int portNo, MockLogger logging) throws IOException {
        super(portNo, "mock");
        this.logging = logging;
        this.start();
        logger.trace((Object)("Started on " + portNo));
    }

    @Override
    protected void register(HttpRequestHandlerRegistry reqistry) {
        logger.trace((Object)"Registered");
        reqistry.register("*", (HttpRequestHandler)new MockWebServiceHandler(this.portNo, this.term, this.logging));
    }

    public void or(Term term2, boolean insertAtEnd) {
        this.term.add(term2, insertAtEnd);
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public void stop() throws IOException {
        super.stop();
        this.term.logUnused(this.portNo, this.logging);
    }
}

