/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.server;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.server.HttpServer;
import fitlibrary.server.WebServerForTesting;
import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class WebServerForTestingFixture {
    private HttpServer server;

    public boolean startFileServerOnPortAtDirectory(int portNo, String diry) throws IOException {
        this.server = new WebServerForTesting(portNo, diry);
        return true;
    }

    public void startLogging() {
        Logger.getRootLogger().setLevel(Level.ALL);
    }

    public boolean stopTestingServerAfterSeconds(long seconds) throws IOException, InterruptedException {
        Thread.sleep(seconds * 1000L);
        return this.stopTestingServer();
    }

    public boolean stopTestingServer() throws IOException {
        if (this.server == null) {
            throw new FitLibraryException("Server is not running");
        }
        this.server.stop();
        this.server = null;
        return true;
    }

    public void tearDown() throws IOException {
        if (this.server != null) {
            this.stopTestingServer();
        }
    }
}

