/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider.utility;

import fit.Fixture;
import fitlibrary.annotation.NullaryAction;
import fitlibrary.annotation.ShowSelectedActions;
import fitlibrary.annotation.SimpleAction;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.spider.SpiderElementFixture;
import fitlibrary.spider.SpiderFixture;
import fitlibrary.spider.utility.WebElementIdentifier;
import fitlibrary.traverse.workflow.DoTraverse;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.openqa.selenium.WebElement;

@ShowSelectedActions
public class WebElementSelector
extends DoTraverse {
    private final SpiderFixture spiderFixture;
    private final String tag;
    private final List<WebElement> elements;

    public WebElementSelector(String tag, List<WebElement> elements, SpiderFixture spiderFixture) {
        this.spiderFixture = spiderFixture;
        this.tag = tag;
        this.elements = elements;
    }

    @NullaryAction(tooltip="Select the remaining element, if one is left.\nSubsequent actions in the same table act on that element.")
    public SpiderElementFixture select() {
        if (this.elements.isEmpty()) {
            throw new FitLibraryException("There are none left selected");
        }
        if (this.elements.size() != 1) {
            throw new FitLibraryException("The following elements are still selected: " + this.descriptions());
        }
        return new SpiderElementFixture(this.elements.get(0), this.spiderFixture);
    }

    private String descriptions() {
        StringBuilder stringBuilder = new StringBuilder();
        for (WebElement element : this.elements) {
            stringBuilder.append(",");
            stringBuilder.append(new WebElementIdentifier(element, this.tag).identify());
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.deleteCharAt(0);
        }
        String descriptions = Fixture.escape((String)stringBuilder.toString());
        return descriptions;
    }

    @SimpleAction(wiki="|''<i>text is</i>''|text|", tooltip="Select those elements which have exactly the given text.")
    public void textIs(final String s) {
        this.filter(new Filter(){

            @Override
            public boolean select(WebElement element) {
                return element.getText().equals(s);
            }
        });
    }

    @SimpleAction(wiki="|''<i>text contains</i>''|text|", tooltip="Select those elements which contain the given text.")
    public void textContains(final String s) {
        this.filter(new Filter(){

            @Override
            public boolean select(WebElement element) {
                return element.getText().contains(s);
            }
        });
    }

    @SimpleAction(wiki="|''<i>text matches</i>''|pattern|", tooltip="Select those elements which match the given pattern (a regular expression).")
    public void textMatches(String pattern) {
        final Pattern compiled = Pattern.compile(".*" + pattern + ".*", 32);
        this.filter(new Filter(){

            @Override
            public boolean select(WebElement element) {
                return compiled.matcher(element.getText()).matches();
            }
        });
    }

    @SimpleAction(wiki="|''<i>attribute</i>''|attribute name|''<i>is</i>''|text|", tooltip="Select those elements which have an attribute value that is the given text.")
    public void attributeIs(final String attribute, final String s) {
        this.filter(new Filter(){

            @Override
            public boolean select(WebElement element) {
                return s.equals(element.getAttribute(attribute));
            }
        });
    }

    @SimpleAction(wiki="|''<i>attribute</i>''|attribute name|''<i>contains</i>''|text|", tooltip="Select those elements which have an attribute value that contain the given text.")
    public void attributeContains(final String attribute, final String s) {
        this.filter(new Filter(){

            @Override
            public boolean select(WebElement element) {
                String value = element.getAttribute(attribute);
                return value != null && value.contains(s);
            }
        });
    }

    @SimpleAction(wiki="|''<i>attribute</i>''|attribute name|''<i>matches</i>''|pattern|", tooltip="Select those elements which have an attribute value that matches the given pattern (a regular expression).")
    public void attributeMatches(final String attribute, String pattern) {
        final Pattern compiled = Pattern.compile(".*" + pattern + ".*", 32);
        this.filter(new Filter(){

            @Override
            public boolean select(WebElement element) {
                String value = element.getAttribute(attribute);
                return value != null && compiled.matcher(value).matches();
            }
        });
    }

    @NullaryAction(tooltip="Show the elements that are left.")
    public void show() {
        this.getRuntimeContext().currentRow().addShow(this.descriptions());
    }

    private void filter(Filter filter) {
        Iterator<WebElement> iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            if (filter.select(iterator.next())) continue;
            iterator.remove();
        }
    }

    static interface Filter {
        public boolean select(WebElement var1);
    }
}

