/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ws.client;

import fit.Fixture;
import fitlibrary.SubsetFixture;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.log.FixturingLogger;
import fitlibrary.ws.client.RelaxedHttpClient;
import fitlibrary.xml.XmlDoFixture;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public class HttpClientService
extends XmlDoFixture {
    private static Logger logger = FixturingLogger.getLogger(HttpClientService.class);
    static int INSTANCES = 0;
    private HttpClient httpClient = null;
    private Header[] headers = new Header[0];
    protected String reply = "";
    protected String replyContentType = "";
    protected boolean acceptAnyCertificate = false;

    public HttpClientService() {
        if (INSTANCES > 0) {
            NDC.push((String)("#" + INSTANCES++));
        }
    }

    public HttpClient client() {
        if (this.httpClient == null) {
            this.httpClient = this.acceptAnyCertificate ? RelaxedHttpClient.create() : new DefaultHttpClient();
        }
        return this.httpClient;
    }

    public boolean acceptAnyCertificate() {
        this.acceptAnyCertificate = true;
        return true;
    }

    public boolean proxyUrlWithPort(String proxyHost, int proxyPortNo) {
        HttpHost proxy = new HttpHost(proxyHost, proxyPortNo, "http");
        this.client().getParams().setParameter("http.route.default-proxy", (Object)proxy);
        return true;
    }

    public void timeout(long socketTimeout) {
        this.client().getParams().setParameter("http.socket.timeout", (Object)socketTimeout);
    }

    public void httpHead(String url) {
        logger.trace((Object)("Try HEAD " + url));
        HttpHead head = new HttpHead(url);
        this.setHost((AbstractHttpMessage)head, url);
        try {
            try {
                this.handleHeaders(this.client().execute((HttpUriRequest)head));
            }
            catch (IOException e) {
                logger.trace((Object)"HEAD failed");
                head.abort();
                throw new FitLibraryException(e.getMessage());
            }
            catch (FitLibraryException e) {
                logger.trace((Object)"HEAD failed");
                head.abort();
                throw e;
            }
        }
        finally {
            logger.trace((Object)"HEAD finished");
        }
    }

    public void httpGet(String url) {
        logger.trace((Object)("Try GET " + url));
        HttpGet get = new HttpGet(url);
        this.setHost((AbstractHttpMessage)get, url);
        try {
            try {
                this.handleReply(this.client().execute((HttpUriRequest)get));
            }
            catch (IOException e) {
                logger.trace((Object)"GET failed");
                get.abort();
                throw new FitLibraryException(e.getMessage());
            }
            catch (FitLibraryException e) {
                logger.trace((Object)"GET failed");
                get.abort();
                throw e;
            }
        }
        finally {
            logger.trace((Object)"GET finished");
        }
    }

    public void httpPost(String url, String contents, String contentType, String contentEncoding) {
        logger.trace((Object)("Start POST " + url + " with content-type " + contentType + " " + contentEncoding));
        logger.trace((Object)("POST " + contents));
        HttpPost post = new HttpPost(url);
        this.setHost((AbstractHttpMessage)post, url);
        this.addExtraHeadersToPost(post);
        try {
            try {
                StringEntity entity = new StringEntity(contents);
                entity.setContentType(contentType);
                entity.setContentEncoding(contentEncoding);
                post.setEntity((HttpEntity)entity);
                logger.trace((Object)"POST executing");
                HttpResponse execute = this.client().execute((HttpUriRequest)post);
                this.handleReply(execute);
            }
            catch (IOException e) {
                logger.trace((Object)"POST failed");
                post.abort();
                throw new FitLibraryException("Problem: " + e.getMessage());
            }
            catch (FitLibraryException e) {
                logger.trace((Object)"POST failed");
                post.abort();
                throw e;
            }
        }
        finally {
            logger.trace((Object)"POST finished");
        }
    }

    private void setHost(AbstractHttpMessage msg, String url) {
        int start = url.indexOf("//") + 2;
        int end = url.indexOf("/", start);
        if (end < 0) {
            end = url.length();
        }
        msg.setHeader("Host", url.substring(start, end));
    }

    protected void addExtraHeadersToPost(HttpPost post) {
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public SubsetFixture headersInclude() {
        return new SubsetFixture((Object)this.getHeaders());
    }

    public String getReply() {
        return this.reply;
    }

    public String getReplyContentType() {
        return this.replyContentType;
    }

    public String getReplyEscaped() {
        return Fixture.escape((String)this.reply).replaceAll("\n", "<br/>");
    }

    private void handleReply(HttpResponse response) throws IOException {
        this.handleHeaders(response);
        Header contentTypeHeader = response.getFirstHeader("Content-type");
        HttpEntity entity = response.getEntity();
        if (entity == null || contentTypeHeader == null) {
            logger.error((Object)"No data returned in response");
            this.replyContentType = "failed";
            throw new FitLibraryException("No data returned");
        }
        this.replyContentType = contentTypeHeader.getValue();
        if (!this.canTreatAsText(this.replyContentType)) {
            throw new FitLibraryException("The data is not text, it has Content-type: " + this.replyContentType);
        }
        this.reply = IOUtils.toString((InputStream)entity.getContent());
        logger.trace((Object)("Reply of " + contentTypeHeader.getName() + ": " + this.replyContentType));
        logger.trace((Object)("Reply: " + this.reply));
        entity.consumeContent();
    }

    private void handleHeaders(HttpResponse response) {
        this.headers = response.getAllHeaders();
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            throw new FitLibraryException("Received Status code = " + statusLine.getStatusCode() + ": " + statusLine.getReasonPhrase());
        }
    }

    private boolean canTreatAsText(String value) {
        return value.contains("text/plain") || value.contains("text/html") || value.contains("text/xml") || value.contains("application/soap+xml");
    }

    public String xpathInResponse(String xPathExpression) {
        return this.xpathIn(xPathExpression, this.reply);
    }

    public boolean xpathExistsInResponse(String xPathExpression) {
        return this.xpathExistsIn(xPathExpression, this.reply);
    }

    public boolean xmlInResponseSameAs(String expectedXml) {
        return this.xmlSameAs(this.reply, expectedXml);
    }
}

