/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ws.logger;

import fitlibrary.ws.clock.Clock;
import fitlibrary.ws.clock.RealClock;
import fitlibrary.ws.logger.Logger;
import fitlibrary.ws.message.HttpMessage;

public class DisplayingLogger
implements Logger {
    private final Clock clock;
    private boolean noisy = true;

    public DisplayingLogger(Clock clock) {
        this.clock = clock;
    }

    public DisplayingLogger() {
        this(new RealClock());
    }

    @Override
    public synchronized void error(String s) {
        System.err.println(String.valueOf(this.clock.dateTime()) + " RecordingLogger Error: " + s);
    }

    @Override
    public synchronized void responded(String context, HttpMessage request, HttpMessage response, int portNo) {
        System.out.println(String.valueOf(this.clock.dateTime()) + context + ":");
        System.out.println("RX\n" + request + "\nEND-RX");
        System.out.println("TT\n" + response + "\nEND-TX");
    }

    @Override
    public synchronized void log(String s) {
        if (this.noisy) {
            System.err.println(String.valueOf(this.clock.dateTime()) + " " + s);
        }
    }

    @Override
    public void unused(int portNo, String expected) {
        this.log("Unused " + portNo + ": " + expected);
    }

    public void beQuiet() {
        this.noisy = false;
    }
}

