/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ws.recorder;

import fitlibrary.log.FixturingLogger;
import fitlibrary.server.ProxyServer;
import fitlibrary.server.UriMapper;
import fitlibrary.ws.recorder.FileRecorder;
import fitlibrary.ws.recorder.RecordingFolderSelector;
import fitlibrary.ws.recorder.UniqueRecordingFolderSelector;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class WebServicesRecorder {
    static Logger logger = FixturingLogger.getLogger(WebServicesRecorder.class);
    private List<ProxyServer> servers = new ArrayList<ProxyServer>();

    public WebServicesRecorder(String propertyFileName, String resultsFolderName, String soapVersion, RecordingFolderSelector recordingFolderSelector) throws IOException {
        Properties properties = this.readProperties(propertyFileName);
        this.createRecorders(properties, resultsFolderName, soapVersion, recordingFolderSelector);
    }

    private void createRecorders(Properties properties, String resultsFolderName, String soapVersion, RecordingFolderSelector recordingFolderSelector) throws IOException {
        int i = 1;
        while (i < 10000) {
            Object localPort = properties.get("localPort" + i);
            Object hostUrl = properties.get("ws" + i);
            if (localPort == null || hostUrl == null) {
                if (i != 1) break;
                System.err.println("At least one port must be defined in the property file");
                logger.error((Object)"At least one port must be defined in the property file");
                return;
            }
            int localPortNo = Integer.parseInt(localPort.toString());
            this.createWebServicesRecorder(localPortNo, hostUrl.toString(), resultsFolderName, soapVersion, recordingFolderSelector);
            ++i;
        }
    }

    private void createWebServicesRecorder(int localPortNo, final String wsUrl, String resultsFolderName, String soapVersion, RecordingFolderSelector recordingFolderSelector) throws IOException {
        FileRecorder fileRecorder = new FileRecorder(localPortNo, resultsFolderName, soapVersion, recordingFolderSelector);
        UriMapper mapper = new UriMapper(){

            @Override
            public String map(String uri, String path) {
                return String.valueOf(wsUrl) + path;
            }
        };
        logger.trace((Object)("Starting (Mapped)ProxyServer for recording on port " + localPortNo + " -> " + wsUrl));
        this.servers.add(new ProxyServer(localPortNo, mapper, fileRecorder));
    }

    private Properties readProperties(String fileName) throws IOException {
        Properties properties = new Properties();
        FileReader reader = new FileReader(new File(fileName));
        properties.load(reader);
        reader.close();
        return properties;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2 && args.length != 3) {
            System.err.println("Usage: fitlibrary.ws.recorder.WebServicesRecorder propertyFileName resultsFolderName [soapVersion]\nwhere the optional soapVersion is SOAP11 or SOAP12 (by default it's SOAP11");
            return;
        }
        String soapVersion = args.length == 3 ? args[2] : "SOAP11";
        WebServicesRecorder webServicesRecorder = new WebServicesRecorder(args[0], args[1], soapVersion, new UniqueRecordingFolderSelector());
    }

    public void stop() throws IOException {
        for (ProxyServer server : this.servers) {
            server.stop();
        }
        this.servers.clear();
    }
}

