/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.csv;

import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.DataFileStream;
import net.sf.jasperreports.data.DataFileUtils;
import net.sf.jasperreports.data.csv.CsvDataAdapter;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRCsvDataSource;

public class CsvDataAdapterService
extends AbstractDataAdapterService {
    private DataFileStream dataStream;

    public CsvDataAdapterService(JasperReportsContext jasperReportsContext, CsvDataAdapter csvDataAdapter) {
        super(jasperReportsContext, csvDataAdapter);
    }

    public CsvDataAdapterService(CsvDataAdapter csvDataAdapter) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), csvDataAdapter);
    }

    public CsvDataAdapter getCsvDataAdapter() {
        return (CsvDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        CsvDataAdapter csvDataAdapter = this.getCsvDataAdapter();
        if (csvDataAdapter != null) {
            this.dataStream = DataFileUtils.instance(this.getJasperReportsContext()).getDataStream(csvDataAdapter.getDataFile(), parameters);
            Locale locale = csvDataAdapter.getLocale();
            TimeZone timeZone = csvDataAdapter.getTimeZone();
            String datePattern = csvDataAdapter.getDatePattern();
            String numberPattern = csvDataAdapter.getNumberPattern();
            if (csvDataAdapter.isQueryExecuterMode()) {
                parameters.put("CSV_INPUT_STREAM", this.dataStream);
                if (csvDataAdapter.getEncoding() != null) {
                    parameters.put("net.sf.jasperreports.csv.encoding", csvDataAdapter.getEncoding());
                }
                if (locale != null) {
                    parameters.put("CSV_LOCALE", locale);
                }
                if (timeZone != null) {
                    parameters.put("CSV_TIMEZONE", timeZone);
                }
                if (datePattern != null && datePattern.length() > 0) {
                    SimpleDateFormat sdf = null;
                    sdf = locale == null ? new SimpleDateFormat(datePattern) : new SimpleDateFormat(datePattern, locale);
                    if (timeZone != null) {
                        sdf.setTimeZone(timeZone);
                    }
                    parameters.put("CSV_DATE_FORMAT", sdf);
                }
                if (numberPattern != null && numberPattern.length() > 0) {
                    DecimalFormat df = null;
                    df = locale == null ? new DecimalFormat(numberPattern) : new DecimalFormat(numberPattern, DecimalFormatSymbols.getInstance(locale));
                    parameters.put("CSV_NUMBER_FORMAT", df);
                }
                parameters.put("net.sf.jasperreports.csv.field.delimiter", csvDataAdapter.getFieldDelimiter());
                parameters.put("net.sf.jasperreports.csv.record.delimiter", csvDataAdapter.getRecordDelimiter());
                parameters.put("CSV_USE_FIRST_ROW_AS_HEADER", new Boolean(csvDataAdapter.isUseFirstRowAsHeader()));
                if (!csvDataAdapter.isUseFirstRowAsHeader()) {
                    parameters.put("CSV_COLUMN_NAMES_ARRAY", this.getColumnNames(csvDataAdapter));
                }
            } else {
                JRCsvDataSource ds = null;
                if (csvDataAdapter.getEncoding() == null) {
                    ds = new JRCsvDataSource(this.dataStream);
                } else {
                    try {
                        ds = new JRCsvDataSource(this.dataStream, csvDataAdapter.getEncoding());
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new JRException(e);
                    }
                }
                if (locale != null) {
                    ds.setLocale(locale);
                }
                if (timeZone != null) {
                    ds.setTimeZone(timeZone);
                }
                if (datePattern != null && datePattern.length() > 0) {
                    SimpleDateFormat sdf = null;
                    sdf = locale == null ? new SimpleDateFormat(datePattern) : new SimpleDateFormat(datePattern, locale);
                    if (timeZone != null) {
                        sdf.setTimeZone(timeZone);
                    }
                    ds.setDateFormat(sdf);
                }
                if (numberPattern != null && numberPattern.length() > 0) {
                    DecimalFormat df = null;
                    df = locale == null ? new DecimalFormat(numberPattern) : new DecimalFormat(numberPattern, DecimalFormatSymbols.getInstance(locale));
                    ds.setNumberFormat(df);
                }
                ds.setFieldDelimiter(csvDataAdapter.getFieldDelimiter().charAt(0));
                ds.setRecordDelimiter(csvDataAdapter.getRecordDelimiter());
                ds.setUseFirstRowAsHeader(csvDataAdapter.isUseFirstRowAsHeader());
                if (!csvDataAdapter.isUseFirstRowAsHeader()) {
                    ds.setColumnNames(this.getColumnNames(csvDataAdapter));
                }
                parameters.put("REPORT_DATA_SOURCE", ds);
            }
        }
    }

    private String[] getColumnNames(CsvDataAdapter csvDataAdapter) {
        String[] names = new String[csvDataAdapter.getColumnNames().size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "" + csvDataAdapter.getColumnNames().get(i);
        }
        return names;
    }

    @Override
    public void dispose() {
        if (this.dataStream != null) {
            this.dataStream.dispose();
        }
        super.dispose();
    }
}

