/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.data.xml.RemoteXmlDataAdapter;
import net.sf.jasperreports.data.xml.XmlDataAdapterService;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class RemoteXmlDataAdapterService
extends XmlDataAdapterService {
    private static final Log log = LogFactory.getLog(RemoteXmlDataAdapterService.class);
    public static final String XML_URL = "XML_URL";

    public RemoteXmlDataAdapterService(JasperReportsContext jasperReportsContext, RemoteXmlDataAdapter remoteXmlDataAdapter) {
        super(jasperReportsContext, remoteXmlDataAdapter);
    }

    public RemoteXmlDataAdapterService(RemoteXmlDataAdapter remoteXmlDataAdapter) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), remoteXmlDataAdapter);
    }

    public RemoteXmlDataAdapter getRemoteXmlDataAdapter() {
        return (RemoteXmlDataAdapter)this.getDataAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        RemoteXmlDataAdapter remoteXmlDataAdapter = this.getRemoteXmlDataAdapter();
        if (remoteXmlDataAdapter != null && remoteXmlDataAdapter.isUseConnection()) {
            String numberPattern;
            String datePattern;
            TimeZone timeZone;
            String fileName = remoteXmlDataAdapter.getFileName();
            if (fileName.toLowerCase().startsWith("https://") || fileName.toLowerCase().startsWith("http://") || fileName.toLowerCase().startsWith("file:")) {
                parameters.put(XML_URL, fileName);
            } else {
                InputStream dataStream = RepositoryUtil.getInstance(this.getJasperReportsContext()).getInputStreamFromLocation(remoteXmlDataAdapter.getFileName());
                try {
                    Document document = JRXmlUtils.parse(dataStream, remoteXmlDataAdapter.isNamespaceAware());
                    parameters.put("XML_DATA_DOCUMENT", document);
                }
                finally {
                    try {
                        dataStream.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)("Failed to close input stream for " + remoteXmlDataAdapter.getFileName()));
                    }
                }
            }
            Locale locale = remoteXmlDataAdapter.getLocale();
            if (locale != null) {
                parameters.put("XML_LOCALE", locale);
            }
            if ((timeZone = remoteXmlDataAdapter.getTimeZone()) != null) {
                parameters.put("XML_TIME_ZONE", timeZone);
            }
            if ((datePattern = remoteXmlDataAdapter.getDatePattern()) != null && datePattern.trim().length() > 0) {
                parameters.put("XML_DATE_PATTERN", datePattern);
            }
            if ((numberPattern = remoteXmlDataAdapter.getNumberPattern()) != null && numberPattern.trim().length() > 0) {
                parameters.put("XML_NUMBER_PATTERN", numberPattern);
            }
        }
    }

    @Override
    public void test() throws JRException {
        RemoteXmlDataAdapter remoteXmlDataAdapter = (RemoteXmlDataAdapter)this.getDataAdapter();
        URL url = null;
        InputStream is = null;
        try {
            String fileName = remoteXmlDataAdapter.getFileName();
            url = new URL(fileName);
            if (fileName.startsWith("file://")) {
                is = url.openStream();
            }
        }
        catch (Exception e) {
            throw new JRException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

