/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import javax.swing.GrayFilter;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.ErrorManager;

public class ImageWidget
extends Widget {
    private Image image;
    private Image disabledImage;
    private int width;
    private int height;
    private boolean paintAsDisabled;
    private ImageObserver observer = new ImageObserver(){

        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 3) != 0) {
                ImageWidget.this.revalidate();
            } else {
                ImageWidget.this.repaint();
            }
            ImageWidget.this.getScene().validate();
            return (infoflags & 0xC0) == 0;
        }
    };

    public ImageWidget(Scene scene) {
        super(scene);
    }

    public ImageWidget(Scene scene, Image image) {
        super(scene);
        this.setImage(image);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (this.image == image) {
            return;
        }
        int oldWidth = this.width;
        int oldHeight = this.height;
        this.image = image;
        this.disabledImage = null;
        this.width = image != null ? image.getWidth(null) : 0;
        int n = this.height = image != null ? image.getHeight(null) : 0;
        if (oldWidth == this.width && oldHeight == this.height) {
            this.repaint();
        } else {
            this.revalidate();
        }
    }

    public boolean isPaintAsDisabled() {
        return this.paintAsDisabled;
    }

    public void setPaintAsDisabled(boolean paintAsDisabled) {
        boolean repaint = this.paintAsDisabled != paintAsDisabled;
        this.paintAsDisabled = paintAsDisabled;
        if (repaint) {
            this.repaint();
        }
    }

    protected Rectangle calculateClientArea() {
        if (this.image != null) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        return super.calculateClientArea();
    }

    protected void paintWidget() {
        if (this.image == null) {
            return;
        }
        Graphics2D gr = this.getGraphics();
        if (this.image != null) {
            if (this.paintAsDisabled) {
                if (this.disabledImage == null) {
                    this.disabledImage = GrayFilter.createDisabledImage(this.image);
                    MediaTracker tracker = new MediaTracker(this.getScene().getView());
                    tracker.addImage(this.disabledImage, 0);
                    try {
                        tracker.waitForAll();
                    }
                    catch (InterruptedException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
                gr.drawImage(this.disabledImage, 0, 0, this.observer);
            } else {
                gr.drawImage(this.image, 0, 0, this.observer);
            }
        }
    }
}

