/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.experimental.widget.general;

import java.awt.Image;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.laf.LookFeel;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.SeparatorWidget;
import org.netbeans.api.visual.widget.Widget;

public class ListWidget
extends Widget {
    private Widget header;
    private ImageWidget imageWidget;
    private LabelWidget labelWidget;

    public ListWidget(Scene scene) {
        super(scene);
        LookFeel lookFeel = scene.getLookFeel();
        this.setOpaque(true);
        this.setBackground(lookFeel.getBackground());
        this.setBorder(BorderFactory.createLineBorder());
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.header = new Widget(scene);
        this.header.setLayout(LayoutFactory.createHorizontalFlowLayout(LayoutFactory.SerialAlignment.CENTER, 0));
        this.imageWidget = new ImageWidget(scene);
        this.header.addChild(this.imageWidget);
        this.labelWidget = new LabelWidget(scene);
        this.header.addChild(this.labelWidget);
        this.addChild(this.header);
        this.addChild(new SeparatorWidget(scene, SeparatorWidget.Orientation.HORIZONTAL));
        this.setState(ObjectState.createNormal());
    }

    public void notifyStateChanged(ObjectState previousState, ObjectState state) {
        LookFeel lookFeel = this.getScene().getLookFeel();
        this.header.setBorder(BorderFactory.createCompositeBorder(BorderFactory.createEmptyBorder(2), lookFeel.getBorder(state)));
        this.labelWidget.setForeground(lookFeel.getForeground(state));
    }

    public final void setImage(Image image) {
        this.imageWidget.setImage(image);
    }

    public final void setLabel(String label) {
        this.labelWidget.setLabel(label);
    }

    public final Widget getHeader() {
        return this.header;
    }

    public final ImageWidget getImageWidget() {
        return this.imageWidget;
    }

    public final LabelWidget getLabelWidget() {
        return this.labelWidget;
    }
}

