/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.util.List;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.DirectedGraph;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.LayeredGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarycenterCrossingMinimizer {
    public LayeredGraph minimizeCrossings(LayeredGraph graph) {
        List<List<DirectedGraph.Vertex>> layers = graph.getLayers();
        if (layers.size() > 1) {
            int maxIteration = 2;
            for (int i = 0; i < maxIteration; ++i) {
                this.minimizeCrossingsPhaseI(graph);
            }
            this.minimizeCrossingsPhaseII(graph);
        }
        return graph;
    }

    private void minimizeCrossingsPhaseI(LayeredGraph graph) {
        int i;
        List<List<DirectedGraph.Vertex>> layers = graph.getLayers();
        int size = layers.size();
        for (i = 0; i < size - 1; ++i) {
            float[] lowerBarycenters = graph.computeLowerBarycenters(i);
            List<DirectedGraph.Vertex> lowerLayer = layers.get(i + 1);
            this.sortVertices(lowerLayer, lowerBarycenters, false);
        }
        for (i = size - 2; i >= 0; --i) {
            float[] upperBarycenters = graph.computeUpperBarycenters(i);
            List<DirectedGraph.Vertex> upperLayer = layers.get(i);
            this.sortVertices(upperLayer, upperBarycenters, false);
        }
    }

    private void minimizeCrossingsPhaseII(LayeredGraph graph) {
        int i;
        List<List<DirectedGraph.Vertex>> layers = graph.getLayers();
        int size = layers.size();
        for (i = size - 2; i >= 0; --i) {
            float[] upperBarycenters = graph.computeUpperBarycenters(i);
            List<DirectedGraph.Vertex> upperLayer = layers.get(i);
            this.sortVertices(upperLayer, upperBarycenters, true);
            this.minimizeCrossingsPhaseI(graph);
        }
        for (i = 0; i < size - 1; ++i) {
            float[] lowerBarycenters = graph.computeLowerBarycenters(i);
            List<DirectedGraph.Vertex> lowerLayer = layers.get(i + 1);
            this.sortVertices(lowerLayer, lowerBarycenters, true);
            this.minimizeCrossingsPhaseI(graph);
        }
    }

    private boolean sortVertices(List<DirectedGraph.Vertex> vertices, float[] barycenters, boolean reverseEqualBarycenters) {
        int size = vertices.size();
        boolean changed = false;
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                DirectedGraph.Vertex jv = vertices.get(j);
                DirectedGraph.Vertex iv = vertices.get(i);
                float jbc = barycenters[j];
                float ibc = barycenters[i];
                boolean swap = false;
                if (reverseEqualBarycenters) {
                    if (jbc <= ibc) {
                        swap = true;
                    }
                } else if (jbc < ibc) {
                    swap = true;
                }
                if (!swap) continue;
                vertices.set(j, iv);
                vertices.set(i, jv);
                barycenters[j] = ibc;
                barycenters[i] = jbc;
                iv.setX(j + 1);
                jv.setX(i + 1);
                changed = true;
            }
        }
        return changed;
    }
}

