/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.FlowNetwork;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.OrthogonalRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimumBendOrthogonalizer {
    public Collection<OrthogonalRepresentation> orthogonalize(Collection<EmbeddedPlanarGraph> epgs) {
        ArrayList<OrthogonalRepresentation> ors = new ArrayList<OrthogonalRepresentation>();
        for (EmbeddedPlanarGraph epg : epgs) {
            FlowNetwork network = FlowNetwork.createGraph(epg);
            this.computeMinimumCostFlowNetwork(network);
            network.removeSourceAndSink();
            OrthogonalRepresentation or = this.computeOrthogonalRepresentation(network);
            ors.add(or);
        }
        return ors;
    }

    private void computeMinimumCostFlowNetwork(FlowNetwork network) {
        FlowNetwork.ResidualFlowNetwork residualNetwork = new FlowNetwork.ResidualFlowNetwork(network);
        int totalFlow = 0;
        int production = network.getSource().getProduction();
        while (totalFlow < production) {
            Collection<FlowNetwork.ResidualArc> path = this.computeDijkstraShortestPath(residualNetwork);
            if (path == null) {
                return;
            }
            int minFlow = Integer.MAX_VALUE;
            for (FlowNetwork.ResidualArc arc : path) {
                int capacity = arc.getCapacity();
                if (capacity >= minFlow) continue;
                minFlow = capacity;
            }
            totalFlow += minFlow;
            for (FlowNetwork.ResidualArc ra : path) {
                FlowNetwork.Arc arc = ra.getArc();
                FlowNetwork.ResidualArc residualArc = null;
                FlowNetwork.ResidualArc reverseResidualArc = null;
                int flow = minFlow;
                if (!ra.isReverse()) {
                    residualArc = ra;
                    reverseResidualArc = residualNetwork.getReverseResidualArcFromArc(arc);
                } else {
                    flow = -flow;
                    reverseResidualArc = ra;
                    residualArc = residualNetwork.getResidualArcFromArc(arc);
                }
                arc.addFlow(flow);
                residualArc.substractCapacity(flow);
                reverseResidualArc.addCapacity(flow);
                reverseResidualArc.setFlow(arc.getFlow());
            }
        }
    }

    private Collection<FlowNetwork.ResidualArc> computeDijkstraShortestPath(FlowNetwork.ResidualFlowNetwork network) {
        Collection<FlowNetwork.Node> nodes = network.getNodes();
        HashMap<FlowNetwork.Node, FlowNetwork.ResidualArc> paths = new HashMap<FlowNetwork.Node, FlowNetwork.ResidualArc>();
        HashMap<FlowNetwork.Node, Integer> distances = new HashMap<FlowNetwork.Node, Integer>();
        FlowNetwork.Node sourceNode = network.getSource();
        for (FlowNetwork.Node node : nodes) {
            distances.put(node, Integer.MAX_VALUE);
        }
        distances.put(sourceNode, 0);
        PriorityQueue<FlowNetwork.Node> priorityQueue = this.createPriorityQueue(distances);
        for (FlowNetwork.Node node : nodes) {
            priorityQueue.offer(node);
        }
        HashSet<FlowNetwork.Node> visitedNodes = new HashSet<FlowNetwork.Node>();
        while (priorityQueue.size() > 0) {
            FlowNetwork.Node node;
            node = priorityQueue.poll();
            if ((Integer)distances.get(node) == Integer.MAX_VALUE || visitedNodes.contains(node)) continue;
            for (FlowNetwork.Arc arc : node.getOutputArcs()) {
                if (arc.getCapacity() <= 0) continue;
                this.computeRelaxation(arc, paths, distances, priorityQueue);
            }
            visitedNodes.add(node);
        }
        ArrayList<FlowNetwork.ResidualArc> shortestPath = new ArrayList<FlowNetwork.ResidualArc>();
        FlowNetwork.Node currentNode = network.getSink();
        while (currentNode != sourceNode) {
            FlowNetwork.Arc arc;
            arc = (FlowNetwork.Arc)paths.get(currentNode);
            if (arc == null) {
                return null;
            }
            shortestPath.add((FlowNetwork.ResidualArc)arc);
            currentNode = arc.getSourceNode();
        }
        return shortestPath;
    }

    private void computeRelaxation(FlowNetwork.Arc arc, Map<FlowNetwork.Node, FlowNetwork.ResidualArc> paths, Map<FlowNetwork.Node, Integer> distances, PriorityQueue<FlowNetwork.Node> queue) {
        int cost;
        FlowNetwork.Node srcNode = arc.getSourceNode();
        FlowNetwork.Node destNode = arc.getDestinationNode();
        int sd = distances.get(srcNode);
        int dd = distances.get(destNode);
        if (dd > sd + (cost = arc.getCost())) {
            distances.put(destNode, sd + cost);
            paths.put(destNode, (FlowNetwork.ResidualArc)arc);
            queue.offer(destNode);
        }
    }

    private PriorityQueue<FlowNetwork.Node> createPriorityQueue(final Map<FlowNetwork.Node, Integer> distances) {
        return new PriorityQueue<FlowNetwork.Node>(distances.size(), new Comparator<FlowNetwork.Node>(){

            @Override
            public int compare(FlowNetwork.Node o1, FlowNetwork.Node o2) {
                int d2;
                int d1 = (Integer)distances.get(o1);
                if (d1 < (d2 = ((Integer)distances.get(o2)).intValue())) {
                    return -1;
                }
                if (d1 == d2) {
                    return 0;
                }
                return 1;
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }
        });
    }

    private OrthogonalRepresentation computeOrthogonalRepresentation(FlowNetwork network) {
        OrthogonalRepresentation or = OrthogonalRepresentation.createGraph(network.getOriginalGraph());
        for (FlowNetwork.Arc arc : network.getArcs()) {
            int i;
            int reverseFlow;
            if (arc.isVertexArc()) {
                MGraph.Vertex v = arc.getSourceNode().getVertex();
                Face f = arc.getDestinationNode().getFace();
                OrthogonalRepresentation.OrthogonalShape shape = or.getShape(f);
                Face.Dart d = arc.getDart();
                OrthogonalRepresentation.Tuple t = shape.getTuple(d);
                t.setAngles(arc.getFlow() + 1);
                continue;
            }
            if (!arc.isFaceArc()) continue;
            FlowNetwork.Node srcNode = arc.getSourceNode();
            FlowNetwork.Node destNode = arc.getDestinationNode();
            Face f = srcNode.getFace();
            FlowNetwork.Arc reverseArc = destNode.getArcToVia(srcNode, arc.getDart());
            OrthogonalRepresentation.OrthogonalShape shape = or.getShape(f);
            Face.Dart d = arc.getDart();
            OrthogonalRepresentation.Tuple t = shape.getTuple(d);
            BitSet bends = t.getBends();
            int forwardFlow = arc.getFlow();
            int sum = forwardFlow + (reverseFlow = reverseArc.getFlow());
            if (sum == 0) continue;
            for (i = 0; i < forwardFlow; ++i) {
                bends.clear(i);
            }
            for (i = forwardFlow; i < sum; ++i) {
                bends.set(i);
            }
            bends.set(sum);
        }
        return or;
    }
}

