/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyLookup
extends Lookup {
    private ImmutableInternalData data;

    public ProxyLookup(Lookup ... lookups) {
        this.data = ImmutableInternalData.EMPTY.setLookupsNoFire(lookups, true);
    }

    protected ProxyLookup() {
        this.data = ImmutableInternalData.EMPTY;
    }

    public synchronized String toString() {
        return "ProxyLookup(class=" + this.getClass() + ")->" + Arrays.asList(this.getData().getLookups(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Lookup[] getLookups() {
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            return this.getData().getLookups(true);
        }
    }

    private Set<Lookup> identityHashSet(Collection<Lookup> current) {
        IdentityHashMap map = new IdentityHashMap();
        for (Lookup lookup : current) {
            map.put(lookup, null);
        }
        return map.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setLookups(Lookup ... lookups) {
        Collection<Reference<R>> arr;
        IdentityHashMap<Lookup.Result, LookupListener> toRemove = new IdentityHashMap<Lookup.Result, LookupListener>();
        IdentityHashMap<Lookup.Result, LookupListener> toAdd = new IdentityHashMap<Lookup.Result, LookupListener>();
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            ImmutableInternalData orig = this.getData();
            ImmutableInternalData newData = this.getData().setLookupsNoFire(lookups, false);
            if (newData == this.getData()) {
                return;
            }
            arr = this.setData(newData, lookups, toAdd, toRemove);
        }
        for (Map.Entry e : toRemove.entrySet()) {
            ((Lookup.Result)e.getKey()).removeLookupListener((LookupListener)e.getValue());
        }
        for (Map.Entry e : toAdd.entrySet()) {
            ((Lookup.Result)e.getKey()).addLookupListener((LookupListener)e.getValue());
        }
        ArrayList<Object> evAndListeners = new ArrayList<Object>();
        for (Reference<R> ref : arr) {
            R r = ref.get();
            if (r == null) continue;
            r.collectFires(evAndListeners);
        }
        Iterator it = evAndListeners.iterator();
        while (it.hasNext()) {
            LookupEvent ev = (LookupEvent)it.next();
            LookupListener l = (LookupListener)it.next();
            l.resultChanged(ev);
        }
    }

    protected void beforeLookup(Lookup.Template<?> template) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> T lookup(Class<T> clazz) {
        Lookup[] tmpLkps;
        this.beforeLookup(new Lookup.Template<T>(clazz));
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            tmpLkps = this.getData().getLookups(false);
        }
        for (int i = 0; i < tmpLkps.length; ++i) {
            T o = tmpLkps[i].lookup(clazz);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        Lookup[] tmpLkps;
        this.beforeLookup(template);
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            tmpLkps = this.getData().getLookups(false);
        }
        for (int i = 0; i < tmpLkps.length; ++i) {
            Lookup.Item<T> o = tmpLkps[i].lookupItem(template);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    private static <T> R<T> convertResult(R r) {
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            ImmutableInternalData[] res = new ImmutableInternalData[]{null};
            R<T> newR = this.getData().findResult(this, res, template);
            this.setData(res[0], this.getData().getLookups(false), null, null);
            return newR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unregisterTemplate(Lookup.Template<?> template) {
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            ImmutableInternalData id = this.getData();
            if (id == null) {
                return;
            }
            this.setData(id.removeTemplate(this, template), this.getData().getLookups(false), null, null);
        }
    }

    private ImmutableInternalData getData() {
        assert (Thread.holdsLock(this));
        return this.data;
    }

    private Collection<Reference<R>> setData(ImmutableInternalData newData, Lookup[] current, Map<Lookup.Result, LookupListener> toAdd, Map<Lookup.Result, LookupListener> toRemove) {
        R r;
        assert (Thread.holdsLock(this));
        assert (newData != null);
        ImmutableInternalData previous = this.getData();
        if (previous == newData) {
            return Collections.emptyList();
        }
        if (newData.isEmpty()) {
            this.setData(newData);
            return Collections.emptyList();
        }
        Collection<Reference<R>> arr = newData.references();
        Set<Lookup> removed = this.identityHashSet(previous.getLookupsList());
        Set<Lookup> currentSet = this.identityHashSet(Arrays.asList(current));
        Set<Lookup> newL = this.identityHashSet(currentSet);
        removed.removeAll(currentSet);
        newL.removeAll(previous.getLookupsList());
        for (Reference<R> ref : arr) {
            r = ref.get();
            if (r == null) continue;
            r.lookupChange(newData, current, previous, newL, removed, toAdd, toRemove);
            if (this.getData() == previous) continue;
        }
        for (Reference<R> ref : arr) {
            r = ref.get();
            if (r == null) continue;
            r.data = newData;
        }
        this.setData(newData);
        return arr;
    }

    private void setData(ImmutableInternalData data) {
        this.data = data;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyInternalData
    extends ImmutableInternalData {
        EmptyInternalData() {
        }

        @Override
        protected final boolean isEmpty() {
            return true;
        }

        @Override
        protected Map<Lookup.Template, Reference<R>> getResults() {
            return Collections.emptyMap();
        }

        @Override
        protected Object getRawLookups() {
            return EMPTY_ARR;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RealInternalData
    extends ImmutableInternalData {
        private final Object lookups;
        private final Map<Lookup.Template, Reference<R>> results;

        public RealInternalData(Object lookups, Map<Lookup.Template, Reference<R>> results) {
            this.results = results;
            this.lookups = lookups;
        }

        @Override
        protected final boolean isEmpty() {
            return false;
        }

        @Override
        protected Map<Lookup.Template, Reference<R>> getResults() {
            boolean strict = false;
            if (!$assertionsDisabled) {
                strict = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            return strict ? Collections.unmodifiableMap(this.results) : this.results;
        }

        @Override
        protected Object getRawLookups() {
            return this.lookups;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SingleInternalData
    extends ImmutableInternalData {
        private final Object lookups;
        private final Lookup.Template template;
        private final Reference<R> result;

        public SingleInternalData(Object lookups, Lookup.Template<?> template, Reference<R> result) {
            this.lookups = lookups;
            this.template = template;
            this.result = result;
        }

        @Override
        protected final boolean isEmpty() {
            return false;
        }

        @Override
        protected Map<Lookup.Template, Reference<R>> getResults() {
            return Collections.singletonMap(this.template, this.result);
        }

        @Override
        protected Object getRawLookups() {
            return this.lookups;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ImmutableInternalData {
        static final ImmutableInternalData EMPTY = new EmptyInternalData();
        static final Lookup[] EMPTY_ARR = new Lookup[0];

        protected ImmutableInternalData() {
        }

        public static ImmutableInternalData create(Object lkp, Map<Lookup.Template, Reference<R>> results) {
            if (results.size() == 0 && lkp == EMPTY_ARR) {
                return EMPTY;
            }
            if (results.size() == 1) {
                Map.Entry<Lookup.Template, Reference<R>> e = results.entrySet().iterator().next();
                return new SingleInternalData(lkp, e.getKey(), e.getValue());
            }
            return new RealInternalData(lkp, results);
        }

        protected abstract boolean isEmpty();

        protected abstract Map<Lookup.Template, Reference<R>> getResults();

        protected abstract Object getRawLookups();

        final Collection<Reference<R>> references() {
            return this.getResults().values();
        }

        final <T> ImmutableInternalData removeTemplate(ProxyLookup proxy, Lookup.Template<T> template) {
            if (this.getResults().containsKey(template)) {
                HashMap<Lookup.Template, Reference<R>> c = new HashMap<Lookup.Template, Reference<R>>(this.getResults());
                Reference<R> ref = c.remove(template);
                if (ref != null && ref.get() != null) {
                    return this;
                }
                return ImmutableInternalData.create(this.getRawLookups(), c);
            }
            return this;
        }

        <T> R<T> findResult(ProxyLookup proxy, ImmutableInternalData[] newData, Lookup.Template<T> template) {
            R r;
            assert (Thread.holdsLock(proxy));
            Map<Lookup.Template, Reference<R>> map = this.getResults();
            Reference<R> ref = map.get(template);
            R r2 = r = ref == null ? null : ref.get();
            if (r != null) {
                newData[0] = this;
                return ProxyLookup.convertResult(r);
            }
            HashMap<Lookup.Template, Reference<R>> res = new HashMap<Lookup.Template, Reference<R>>(map);
            R<T> newR = new R<T>(proxy, template);
            res.put(template, new SoftReference<R<T>>(newR));
            newData[0] = ImmutableInternalData.create(this.getRawLookups(), res);
            ((R)newR).data = newData[0];
            return newR;
        }

        final ImmutableInternalData setLookupsNoFire(Lookup[] lookups, boolean skipCheck) {
            Object l;
            if (!skipCheck) {
                Lookup[] previous = this.getLookups(false);
                if (previous == lookups) {
                    return this;
                }
                if (previous.length == lookups.length) {
                    int same = 0;
                    for (int i = 0; i < previous.length && lookups[i] == previous[i]; ++i) {
                        ++same;
                    }
                    if (same == previous.length) {
                        return this;
                    }
                }
            }
            if (lookups.length == 1) {
                l = lookups[0];
                assert (l != null) : "Cannot assign null delegate";
            } else {
                l = lookups.length == 0 ? EMPTY_ARR : lookups.clone();
            }
            if (this.isEmpty() && l == EMPTY_ARR) {
                return this;
            }
            return ImmutableInternalData.create(l, this.getResults());
        }

        final Lookup[] getLookups(boolean clone) {
            Object l = this.getRawLookups();
            if (l instanceof Lookup) {
                return new Lookup[]{(Lookup)l};
            }
            Lookup[] arr = (Lookup[])l;
            if (clone) {
                arr = (Lookup[])arr.clone();
            }
            return arr;
        }

        final List<Lookup> getLookupsList() {
            return Arrays.asList(this.getLookups(false));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WeakResult<T>
    extends WaitableResult<T>
    implements LookupListener,
    Runnable {
        private Lookup.Result<T>[] results;
        private final WeakRef<T> result;

        public WeakResult(ProxyLookup proxy, R r, Lookup.Template<T> t) {
            this.result = new WeakRef<T>(r, this, proxy, t);
        }

        final void removeListeners() {
            Lookup.Result<T>[] arr = this.getResults();
            if (arr == null) {
                return;
            }
            for (int i = 0; i < arr.length; ++i) {
                arr[i].removeLookupListener(this);
            }
        }

        @Override
        protected void beforeLookup(Lookup.Template t) {
            R r = (R)this.result.get();
            if (r != null) {
                r.beforeLookup(t);
            } else {
                this.removeListeners();
            }
        }

        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            R r = (R)this.result.get();
            if (r != null) {
                r.collectFires(evAndListeners);
            } else {
                this.removeListeners();
            }
        }

        @Override
        public void addLookupListener(LookupListener l) {
            assert (false);
        }

        @Override
        public void removeLookupListener(LookupListener l) {
            assert (false);
        }

        @Override
        public Collection<T> allInstances() {
            assert (false);
            return null;
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            R r = (R)this.result.get();
            if (r != null) {
                r.resultChanged(ev);
            } else {
                this.removeListeners();
            }
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            assert (false);
            return null;
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            assert (false);
            return null;
        }

        @Override
        public void run() {
            this.removeListeners();
        }

        private Lookup.Result<T>[] getResults() {
            return this.results;
        }

        private void setResults(Lookup.Result<T>[] results) {
            this.results = results;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WeakRef<T>
    extends WeakReference<R>
    implements Runnable {
        final WeakResult<T> result;
        final ProxyLookup proxy;
        final Lookup.Template<T> template;

        public WeakRef(R r, WeakResult<T> result, ProxyLookup proxy, Lookup.Template<T> template) {
            super(r);
            this.result = result;
            this.template = template;
            this.proxy = proxy;
        }

        @Override
        public void run() {
            this.result.removeListeners();
            this.proxy.unregisterTemplate(this.template);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class R<T>
    extends WaitableResult<T> {
        private final WeakResult<T> weakL;
        private EventListenerList listeners;
        private Collection[] cache;
        private ImmutableInternalData data;

        public R(ProxyLookup proxy, Lookup.Template<T> t) {
            this.weakL = new WeakResult<T>(proxy, this, t);
        }

        private ProxyLookup proxy() {
            return ((WeakResult)this.weakL).result.proxy;
        }

        private Lookup.Result<T>[] newResults(int len) {
            return new Lookup.Result[len];
        }

        protected void finalize() {
            ((WeakResult)this.weakL).result.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private Lookup.Result<T>[] initResults() {
            int i;
            Lookup.Result[] arr;
            block4: while (true) {
                ProxyLookup proxyLookup = this.proxy();
                // MONITORENTER : proxyLookup
                if (((WeakResult)this.weakL).getResults() != null) {
                    // MONITOREXIT : proxyLookup
                    return ((WeakResult)this.weakL).getResults();
                }
                Lookup[] myLkps = this.data.getLookups(false);
                ImmutableInternalData current = this.data;
                // MONITOREXIT : proxyLookup
                arr = this.newResults(myLkps.length);
                for (int i2 = 0; i2 < arr.length; ++i2) {
                    arr[i2] = myLkps[i2].lookup(((WeakResult)this.weakL).result.template);
                }
                ProxyLookup proxyLookup2 = this.proxy();
                // MONITORENTER : proxyLookup2
                if (current != this.data) {
                    // MONITOREXIT : proxyLookup2
                    continue;
                }
                Lookup[] currentLkps = this.data.getLookups(false);
                if (currentLkps.length != myLkps.length) {
                    // MONITOREXIT : proxyLookup2
                    continue;
                }
                for (i = 0; i < currentLkps.length; ++i) {
                    if (currentLkps[i] == myLkps[i]) continue;
                    // MONITOREXIT : proxyLookup2
                    continue block4;
                }
                break;
            }
            if (((WeakResult)this.weakL).getResults() != null) {
                // MONITOREXIT : proxyLookup2
                return ((WeakResult)this.weakL).getResults();
            }
            i = 0;
            while (true) {
                if (i >= arr.length) {
                    ((WeakResult)this.weakL).setResults(arr);
                    // MONITOREXIT : proxyLookup2
                    return arr;
                }
                arr[i].addLookupListener(this.weakL);
                ++i;
            }
        }

        final void lookupChange(ImmutableInternalData newData, Lookup[] current, ImmutableInternalData oldData, Set<Lookup> added, Set<Lookup> removed, Map<Lookup.Result, LookupListener> toAdd, Map<Lookup.Result, LookupListener> toRemove) {
            if (((WeakResult)this.weakL).getResults() == null) {
                return;
            }
            Lookup[] old = oldData.getLookups(false);
            IdentityHashMap<Lookup, Lookup.Result> map = new IdentityHashMap<Lookup, Lookup.Result>(old.length * 2);
            for (int i = 0; i < old.length; ++i) {
                if (removed.contains(old[i])) {
                    if (toRemove == null) continue;
                    toRemove.put(((WeakResult)this.weakL).getResults()[i], this.weakL);
                    continue;
                }
                map.put(old[i], ((WeakResult)this.weakL).getResults()[i]);
            }
            Lookup.Result[] arr = this.newResults(current.length);
            for (int i = 0; i < current.length; ++i) {
                if (added.contains(current[i])) {
                    arr[i] = current[i].lookup(((WeakResult)this.weakL).result.template);
                    if (toAdd == null) continue;
                    toAdd.put(arr[i], this.weakL);
                    continue;
                }
                arr[i] = (Lookup.Result)map.get(current[i]);
                if (arr[i] != null) continue;
                throw new IllegalStateException();
            }
            ((WeakResult)this.weakL).setResults(arr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLookupListener(LookupListener l) {
            ProxyLookup proxyLookup = this.proxy();
            synchronized (proxyLookup) {
                if (this.listeners == null) {
                    this.listeners = new EventListenerList();
                }
            }
            this.listeners.add(LookupListener.class, l);
        }

        @Override
        public void removeLookupListener(LookupListener l) {
            if (this.listeners != null) {
                this.listeners.remove(LookupListener.class, l);
            }
        }

        @Override
        public Collection<T> allInstances() {
            return this.computeResult(0);
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            return (Set)this.computeResult(1);
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            return this.computeResult(2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection computeResult(int indexToCache) {
            Collection ret;
            AbstractCollection compute;
            Lookup.Result<T>[] arr = this.myBeforeLookup();
            ProxyLookup proxyLookup = this.proxy();
            synchronized (proxyLookup) {
                Collection result;
                if (this.getCache() != null && (result = this.getCache()[indexToCache]) != null) {
                    return result;
                }
            }
            if (indexToCache == 1) {
                HashSet s = new HashSet();
                compute = s;
                ret = Collections.unmodifiableSet(s);
            } else {
                ArrayList l = new ArrayList(arr.length * 2);
                compute = l;
                ret = Collections.unmodifiableList(l);
            }
            block11: for (int i = 0; i < arr.length; ++i) {
                switch (indexToCache) {
                    case 0: {
                        compute.addAll(arr[i].allInstances());
                        continue block11;
                    }
                    case 1: {
                        compute.addAll(arr[i].allClasses());
                        continue block11;
                    }
                    case 2: {
                        compute.addAll(arr[i].allItems());
                        continue block11;
                    }
                    default: {
                        assert (false) : "Wrong index: " + indexToCache;
                        continue block11;
                    }
                }
            }
            ProxyLookup proxyLookup2 = this.proxy();
            synchronized (proxyLookup2) {
                if (this.getCache() == null) {
                    this.setCache(new Collection[3]);
                }
                if (arr == ((WeakResult)this.weakL).getResults()) {
                    this.getCache()[indexToCache] = ret;
                }
            }
            return ret;
        }

        public void resultChanged(LookupEvent ev) {
            this.collectFires(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            Collection<T> newInstances;
            Collection oldItems;
            Collection oldInstances;
            ProxyLookup proxyLookup = this.proxy();
            synchronized (proxyLookup) {
                if (this.getCache() == null) {
                    return;
                }
                oldInstances = this.getCache()[0];
                oldItems = this.getCache()[2];
                if (this.listeners == null || this.listeners.getListenerCount() == 0) {
                    this.setCache(new Collection[3]);
                    return;
                }
                this.setCache(null);
            }
            boolean modified = true;
            if (oldItems != null) {
                Collection<Lookup.Item<T>> newItems = this.allItems();
                if (((Object)oldItems).equals(newItems)) {
                    modified = false;
                }
            } else if (oldInstances != null) {
                newInstances = this.allInstances();
                if (((Object)oldInstances).equals(newInstances)) {
                    modified = false;
                }
            } else {
                newInstances = this.proxy();
                synchronized (newInstances) {
                    if (this.getCache() == null) {
                        this.setCache(new Collection[3]);
                    }
                }
            }
            if (modified) {
                LookupEvent ev = new LookupEvent(this);
                AbstractLookup.notifyListeners(this.listeners.getListenerList(), ev, evAndListeners);
            }
        }

        private Lookup.Result<T>[] myBeforeLookup() {
            Lookup.Template template = ((WeakResult)this.weakL).result.template;
            this.proxy().beforeLookup(template);
            Lookup.Result<T>[] arr = this.initResults();
            for (int i = 0; i < arr.length; ++i) {
                if (!(arr[i] instanceof WaitableResult)) continue;
                WaitableResult w = (WaitableResult)arr[i];
                w.beforeLookup(template);
            }
            return arr;
        }

        @Override
        protected void beforeLookup(Lookup.Template t) {
            if (t.getType() == ((WeakResult)this.weakL).result.template.getType()) {
                this.myBeforeLookup();
            }
        }

        private Collection[] getCache() {
            return this.cache;
        }

        private void setCache(Collection[] cache) {
            assert (Thread.holdsLock(this.proxy()));
            this.cache = cache;
        }
    }
}

