/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.xml;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.ActiveXObject;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDocument;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.WebResponseWrapper;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.auth.UsernamePasswordCredentials;

@JsxClass(browsers={@WebBrowser(value=BrowserName.IE, minVersion=7.0f), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
public class XMLHttpRequest
extends SimpleScriptable {
    private static final Log LOG = LogFactory.getLog(XMLHttpRequest.class);
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_LOADED = 2;
    public static final int STATE_INTERACTIVE = 3;
    public static final int STATE_COMPLETED = 4;
    private static final String[] ALL_PROPERTIES_ = new String[]{"onreadystatechange", "readyState", "responseText", "responseXML", "status", "statusText", "abort", "getAllResponseHeaders", "getResponseHeader", "open", "send", "setRequestHeader"};
    private static Collection<String> PROHIBITED_HEADERS_ = Arrays.asList("accept-charset", "accept-encoding", "connection", "content-length", "cookie", "cookie2", "content-transfer-encoding", "date", "expect", "host", "keep-alive", "referer", "te", "trailer", "transfer-encoding", "upgrade", "user-agent", "via");
    private int state_;
    private Function stateChangeHandler_;
    private Function loadHandler_;
    private Function errorHandler_;
    private WebRequest webRequest_;
    private boolean async_;
    private int threadID_;
    private WebResponse webResponse_;
    private String overriddenMimeType_;
    private HtmlPage containingPage_;
    private final boolean caseSensitiveProperties_;
    private boolean withCredentials_;

    public XMLHttpRequest() {
        this(true);
    }

    public XMLHttpRequest(boolean caseSensitiveProperties) {
        this.caseSensitiveProperties_ = caseSensitiveProperties;
        this.state_ = 0;
    }

    @JsxConstructor
    public void jsConstructor() {
    }

    @JsxGetter
    public Function getOnreadystatechange() {
        return this.stateChangeHandler_;
    }

    @JsxSetter
    public void setOnreadystatechange(Function stateChangeHandler) {
        this.stateChangeHandler_ = stateChangeHandler;
        if (this.state_ == 1) {
            this.setState(this.state_, null);
        }
    }

    private void setState(int state, Context context) {
        boolean triggerOnload;
        boolean triggerForSyncCompleted;
        this.state_ = state;
        BrowserVersion browser = this.getBrowserVersion();
        boolean noTriggerForSync = browser.hasFeature(BrowserVersionFeatures.XHR_ONREADYSTATECANGE_SYNC_REQUESTS_NOT_TRIGGERED);
        boolean bl = triggerForSyncCompleted = state == 4 && browser.hasFeature(BrowserVersionFeatures.XHR_ONREADYSTATECANGE_SYNC_REQUESTS_COMPLETED);
        if (this.stateChangeHandler_ != null && (this.async_ || !noTriggerForSync || triggerForSyncCompleted)) {
            Scriptable scope = this.stateChangeHandler_.getParentScope();
            JavaScriptEngine jsEngine = this.containingPage_.getWebClient().getJavaScriptEngine();
            int nbExecutions = this.async_ && 1 == state ? 2 : 1;
            Scriptable thisValue = browser.hasFeature(BrowserVersionFeatures.XHR_HANDLER_THIS_IS_FUNCTION) ? this.stateChangeHandler_ : this;
            for (int i = 0; i < nbExecutions; ++i) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Calling onreadystatechange handler for state " + state);
                }
                Object[] params = ArrayUtils.EMPTY_OBJECT_ARRAY;
                if (browser.hasFeature(BrowserVersionFeatures.XHR_ONREADYSTATECHANGE_WITH_EVENT_PARAM)) {
                    params = new Object[1];
                    Event event = new Event(this, "readystatechange");
                    params[0] = event;
                }
                jsEngine.callFunction(this.containingPage_, this.stateChangeHandler_, scope, thisValue, params);
                if (!LOG.isDebugEnabled()) continue;
                if (context == null) {
                    context = Context.getCurrentContext();
                }
                LOG.debug("onreadystatechange handler: " + context.decompileFunction(this.stateChangeHandler_, 4));
                LOG.debug("Calling onreadystatechange handler for state " + state + ". Done.");
            }
        }
        if ((triggerOnload = browser.hasFeature(BrowserVersionFeatures.XHR_TRIGGER_ONLOAD_ON_COMPLETED)) && this.loadHandler_ != null && state == 4) {
            Scriptable scope = this.loadHandler_.getParentScope();
            JavaScriptEngine jsEngine = this.containingPage_.getWebClient().getJavaScriptEngine();
            jsEngine.callFunction(this.containingPage_, this.loadHandler_, scope, this, ArrayUtils.EMPTY_OBJECT_ARRAY);
        }
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=6.0f), @WebBrowser(value=BrowserName.FF)})
    public Function getOnload() {
        return this.loadHandler_;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=6.0f), @WebBrowser(value=BrowserName.FF)})
    public void setOnload(Function loadHandler) {
        this.loadHandler_ = loadHandler;
    }

    @JsxGetter
    public Function getOnerror() {
        return this.errorHandler_;
    }

    @JsxSetter
    public void setOnerror(Function errorHandler) {
        this.errorHandler_ = errorHandler;
    }

    private void processError(Context context) {
        if (this.errorHandler_ != null && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_ERRORHANDLER_NOT_SUPPORTED)) {
            Scriptable scope = this.errorHandler_.getParentScope();
            JavaScriptEngine jsEngine = this.containingPage_.getWebClient().getJavaScriptEngine();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Calling onerror handler");
            }
            jsEngine.callFunction(this.containingPage_, this.errorHandler_, (Scriptable)this, scope, ArrayUtils.EMPTY_OBJECT_ARRAY);
            if (LOG.isDebugEnabled()) {
                if (context == null) {
                    context = Context.getCurrentContext();
                }
                LOG.debug("onerror handler: " + context.decompileFunction(this.errorHandler_, 4));
                LOG.debug("Calling onerror handler done.");
            }
        }
    }

    @JsxGetter
    public int getReadyState() {
        return this.state_;
    }

    @JsxGetter
    public String getResponseText() {
        if (this.webResponse_ != null) {
            return this.webResponse_.getContentAsString();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("XMLHttpRequest.responseText was retrieved before the response was available.");
        }
        return "";
    }

    @JsxGetter
    public Object getResponseXML() {
        if (this.webResponse_ == null) {
            return null;
        }
        if (this.webResponse_ instanceof NetworkErrorWebResponse) {
            return null;
        }
        String contentType = this.webResponse_.getContentType();
        if (contentType.isEmpty() || contentType.contains("xml")) {
            try {
                XMLDocument doc;
                XmlPage page = new XmlPage(this.webResponse_, this.getWindow().getWebWindow());
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_SUPPORT_VIA_ACTIVEXOBJECT)) {
                    doc = ActiveXObject.buildXMLDocument(this.getWindow().getWebWindow());
                } else {
                    doc = new XMLDocument();
                    doc.setPrototype(this.getPrototype(doc.getClass()));
                }
                doc.setParentScope(this.getWindow());
                doc.setDomNode(page);
                return doc;
            }
            catch (IOException e) {
                LOG.warn("Failed parsing XML document " + this.webResponse_.getWebRequest().getUrl() + ": " + e.getMessage());
                return null;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("XMLHttpRequest.responseXML was called but the response is " + this.webResponse_.getContentType());
        }
        return null;
    }

    @JsxGetter
    public int getStatus() {
        if (this.webResponse_ != null) {
            return this.webResponse_.getStatusCode();
        }
        LOG.error("XMLHttpRequest.status was retrieved before the response was available.");
        return 0;
    }

    @JsxGetter
    public String getStatusText() {
        if (this.webResponse_ != null) {
            return this.webResponse_.getStatusMessage();
        }
        LOG.error("XMLHttpRequest.statusText was retrieved before the response was available.");
        return null;
    }

    @JsxFunction
    public void abort() {
        this.getWindow().getWebWindow().getJobManager().stopJob(this.threadID_);
    }

    @JsxFunction
    public String getAllResponseHeaders() {
        if (this.webResponse_ != null) {
            StringBuilder buffer = new StringBuilder();
            for (NameValuePair header : this.webResponse_.getResponseHeaders()) {
                buffer.append(header.getName()).append(": ").append(header.getValue()).append("\n");
            }
            return buffer.toString();
        }
        LOG.error("XMLHttpRequest.getAllResponseHeaders() was called before the response was available.");
        return null;
    }

    @JsxFunction
    public String getResponseHeader(String headerName) {
        if (this.webResponse_ != null) {
            return this.webResponse_.getResponseHeaderValue(headerName);
        }
        return null;
    }

    @JsxFunction
    public void open(String method, Object urlParam, boolean async, Object user, Object password) {
        if ((urlParam == null || "".equals(urlParam)) && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_OPEN_ALLOW_EMTPY_URL)) {
            throw Context.reportRuntimeError("URL for XHR.open can't be empty!");
        }
        String url = Context.toString(urlParam);
        this.containingPage_ = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        try {
            URL fullUrl = this.containingPage_.getFullyQualifiedUrl(url);
            URL originUrl = this.containingPage_.getUrl();
            if (!this.isAllowCrossDomainsFor(originUrl, fullUrl)) {
                throw Context.reportRuntimeError("Access to restricted URI denied");
            }
            WebRequest request = new WebRequest(fullUrl);
            request.setCharset("UTF-8");
            request.setAdditionalHeader("Referer", this.containingPage_.getUrl().toExternalForm());
            if (!this.isSameOrigin(originUrl, fullUrl) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_ORIGIN_HEADER)) {
                StringBuilder origin = new StringBuilder().append(originUrl.getProtocol()).append("://").append(originUrl.getHost());
                if (originUrl.getPort() != -1) {
                    origin.append(':').append(originUrl.getPort());
                }
                request.setAdditionalHeader("Origin", origin.toString());
            }
            request.setHttpMethod(HttpMethod.valueOf(method.toUpperCase()));
            if (Undefined.instance != user || Undefined.instance != password) {
                String userCred = null;
                String passwordCred = "";
                if (Undefined.instance != user) {
                    userCred = user.toString();
                }
                if (Undefined.instance != password) {
                    passwordCred = user.toString();
                }
                if (null != userCred) {
                    request.setCredentials(new UsernamePasswordCredentials(userCred, passwordCred));
                }
            }
            this.webRequest_ = request;
        }
        catch (MalformedURLException e) {
            LOG.error("Unable to initialize XMLHttpRequest using malformed URL '" + url + "'.");
            return;
        }
        this.async_ = async;
        this.setState(1, null);
    }

    private boolean isAllowCrossDomainsFor(URL originUrl, URL newUrl) {
        BrowserVersion browser = this.getBrowserVersion();
        if (browser.hasFeature(BrowserVersionFeatures.XHR_IGNORE_SAME_ORIGIN)) {
            return true;
        }
        if (browser.hasFeature(BrowserVersionFeatures.XHR_IGNORE_SAME_ORIGIN_TO_ABOUT) && "about".equals(newUrl.getProtocol())) {
            return true;
        }
        return originUrl.getHost().equals(newUrl.getHost());
    }

    private boolean isSameOrigin(URL originUrl, URL newUrl) {
        int newPort;
        if (!originUrl.getHost().equals(newUrl.getHost())) {
            return false;
        }
        int originPort = originUrl.getPort();
        if (originPort == -1) {
            originPort = originUrl.getDefaultPort();
        }
        if ((newPort = newUrl.getPort()) == -1) {
            newPort = newUrl.getDefaultPort();
        }
        return originPort == newPort;
    }

    @JsxFunction
    public void send(Object content) {
        this.prepareRequest(content);
        WebClient client = this.getWindow().getWebWindow().getWebClient();
        AjaxController ajaxController = client.getAjaxController();
        HtmlPage page = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        boolean synchron = ajaxController.processSynchron(page, this.webRequest_, this.async_);
        if (synchron) {
            this.doSend(Context.getCurrentContext());
        } else {
            final Window startingScope = this.getWindow();
            HtmlUnitContextFactory cf = client.getJavaScriptEngine().getContextFactory();
            ContextAction action = new ContextAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run(Context cx) {
                    Stack<Scriptable> stack = (Stack<Scriptable>)cx.getThreadLocal("startingScope");
                    if (null == stack) {
                        stack = new Stack<Scriptable>();
                        cx.putThreadLocal("startingScope", stack);
                    }
                    stack.push(startingScope);
                    try {
                        XMLHttpRequest.this.doSend(cx);
                    }
                    finally {
                        stack.pop();
                    }
                    return null;
                }
            };
            JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createJavascriptXMLHttpRequestJob(cf, action);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting XMLHttpRequest thread for asynchronous request");
            }
            this.threadID_ = this.getWindow().getWebWindow().getJobManager().addJob(job, page);
        }
    }

    private void prepareRequest(Object content) {
        String body;
        if (!(content == null || HttpMethod.POST != this.webRequest_.getHttpMethod() && HttpMethod.PUT != this.webRequest_.getHttpMethod() || Context.getUndefinedValue().equals(content) || (body = Context.toString(content)).length() <= 0)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting request body to: " + body);
            }
            this.webRequest_.setRequestBody(body);
        }
    }

    private void doSend(Context context) {
        WebClient wc = this.getWindow().getWebWindow().getWebClient();
        try {
            boolean crossOriginResourceSharing;
            this.setState(2, context);
            boolean bl = crossOriginResourceSharing = this.webRequest_.getAdditionalHeaders().get("Origin") != null;
            if (crossOriginResourceSharing && this.isPreflight()) {
                WebRequest preflightRequest = new WebRequest(this.webRequest_.getUrl(), HttpMethod.OPTIONS);
                preflightRequest.setAdditionalHeader("Origin", this.webRequest_.getAdditionalHeaders().get("Origin"));
                preflightRequest.setAdditionalHeader("Access-Control-Request-Method", this.webRequest_.getHttpMethod().name());
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<String, String> header : this.webRequest_.getAdditionalHeaders().entrySet()) {
                    String value;
                    String name = header.getKey().toLowerCase();
                    if (!this.isPreflightHeader(name, value = header.getValue().toLowerCase())) continue;
                    if (builder.length() != 0) {
                        builder.append(' ');
                    }
                    builder.append(name);
                }
                preflightRequest.setAdditionalHeader("Access-Control-Request-Headers", builder.toString());
                WebResponse preflightResponse = wc.loadWebResponse(preflightRequest);
                if (!this.isPreflightAuthorized(preflightResponse)) {
                    this.setState(3, context);
                    this.setState(4, context);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No permitted request for URL " + this.webRequest_.getUrl());
                    }
                    Context.throwAsScriptRuntimeEx(new RuntimeException("No permitted \"Access-Control-Allow-Origin\" header."));
                    return;
                }
            }
            WebResponse webResponse = wc.loadWebResponse(this.webRequest_);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Web response loaded successfully.");
            }
            boolean allowOriginResponse = true;
            if (crossOriginResourceSharing) {
                String value = webResponse.getResponseHeaderValue("Access-Control-Allow-Origin");
                boolean bl2 = allowOriginResponse = "*".equals(value) || this.webRequest_.getAdditionalHeaders().get("Origin").equals(value);
            }
            if (allowOriginResponse) {
                this.webResponse_ = this.overriddenMimeType_ == null ? webResponse : new WebResponseWrapper(webResponse){

                    @Override
                    public String getContentType() {
                        return XMLHttpRequest.this.overriddenMimeType_;
                    }
                };
            }
            this.setState(3, context);
            this.setState(4, context);
            if (!allowOriginResponse) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No permitted \"Access-Control-Allow-Origin\" header for URL " + this.webRequest_.getUrl());
                }
                throw new IOException("No permitted \"Access-Control-Allow-Origin\" header.");
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("IOException: returning a network error response.", e);
            }
            this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_);
            this.setState(4, context);
            if (this.async_) {
                this.processError(context);
            }
            Context.throwAsScriptRuntimeEx(e);
        }
    }

    private boolean isPreflight() {
        HttpMethod method = this.webRequest_.getHttpMethod();
        if (method != HttpMethod.GET && method != HttpMethod.PUT && method != HttpMethod.HEAD) {
            return true;
        }
        for (Map.Entry<String, String> header : this.webRequest_.getAdditionalHeaders().entrySet()) {
            if (!this.isPreflightHeader(header.getKey().toLowerCase(), header.getValue().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private boolean isPreflightAuthorized(WebResponse preflightResponse) {
        String originHeader = preflightResponse.getResponseHeaderValue("Access-Control-Allow-Origin");
        if (!"*".equals(originHeader) && !this.webRequest_.getAdditionalHeaders().get("Origin").equals(originHeader)) {
            return false;
        }
        String headersHeader = preflightResponse.getResponseHeaderValue("Access-Control-Allow-Headers");
        headersHeader = headersHeader == null ? "" : headersHeader.toLowerCase();
        for (Map.Entry<String, String> header : this.webRequest_.getAdditionalHeaders().entrySet()) {
            if (!this.isPreflightHeader(header.getKey().toLowerCase(), header.getValue().toLowerCase()) || headersHeader.contains(header.getKey().toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private boolean isPreflightHeader(String name, String value) {
        if ("content-type".equals(name)) {
            return !"application/x-www-form-urlencoded".equals(value) && !"multipart/form-data".equals(value) && !"text/plain".equals(value) && !value.startsWith("text/plain;charset=");
        }
        return !"accept".equals(name) && !"accept-language".equals(name) && !"content-language".equals(name) && !"referer".equals(name) && !"accept-encoding".equals(name) && !"origin".equals(name);
    }

    @JsxFunction
    public void setRequestHeader(String name, String value) {
        if (!XMLHttpRequest.isAuthorizedHeader(name)) {
            LOG.warn("Ignoring XMLHttpRequest.setRequestHeader for " + name + ": it is a restricted header");
            return;
        }
        if (this.webRequest_ == null) {
            throw Context.reportRuntimeError("The open() method must be called before setRequestHeader().");
        }
        this.webRequest_.setAdditionalHeader(name, value);
    }

    static boolean isAuthorizedHeader(String name) {
        String nameLowerCase = name.toLowerCase();
        if (PROHIBITED_HEADERS_.contains(nameLowerCase)) {
            return false;
        }
        return !nameLowerCase.startsWith("proxy-") && !nameLowerCase.startsWith("sec-");
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, maxVersion=6.0f), @WebBrowser(value=BrowserName.FF)})
    public void overrideMimeType(String mimeType) {
        this.overriddenMimeType_ = mimeType;
    }

    @JsxGetter
    public boolean getWithCredentials() {
        return this.withCredentials_;
    }

    @JsxSetter
    public void setWithCredentials(boolean withCredentials) {
        this.withCredentials_ = withCredentials;
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (!this.caseSensitiveProperties_) {
            for (String property : ALL_PROPERTIES_) {
                if (!property.equalsIgnoreCase(name)) continue;
                name = property;
                break;
            }
        }
        return super.get(name, start);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (!this.caseSensitiveProperties_) {
            for (String property : ALL_PROPERTIES_) {
                if (!property.equalsIgnoreCase(name)) continue;
                name = property;
                break;
            }
        }
        super.put(name, start, value);
    }

    private static final class NetworkErrorWebResponse
    extends WebResponse {
        private final WebRequest request_;

        private NetworkErrorWebResponse(WebRequest webRequest) {
            super(null, null, 0L);
            this.request_ = webRequest;
        }

        @Override
        public int getStatusCode() {
            return 0;
        }

        @Override
        public String getStatusMessage() {
            return "";
        }

        @Override
        public String getContentType() {
            return "";
        }

        @Override
        public String getContentAsString() {
            return "";
        }

        @Override
        public String getContentAsString(String encoding) {
            return "";
        }

        @Override
        public InputStream getContentAsStream() {
            return null;
        }

        @Override
        public List<NameValuePair> getResponseHeaders() {
            return Collections.emptyList();
        }

        @Override
        public String getResponseHeaderValue(String headerName) {
            return "";
        }

        @Override
        public long getLoadTime() {
            return 0L;
        }

        @Override
        public String getContentCharset() {
            return "";
        }

        @Override
        public String getContentCharsetOrNull() {
            return "";
        }

        @Override
        public WebRequest getWebRequest() {
            return this.request_;
        }
    }
}

