/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EncodingSniffer {
    private static final Log LOG = LogFactory.getLog(EncodingSniffer.class);
    static final String UTF16_LE = "UTF-16LE";
    static final String UTF16_BE = "UTF-16BE";
    static final String UTF8 = "UTF-8";
    private static final byte[][] COMMENT_START = new byte[][]{{60}, {33}, {45}, {45}};
    private static final byte[][] META_START = new byte[][]{{60}, {109, 77}, {101, 69}, {116, 84}, {97, 65}, {9, 10, 12, 13, 32, 47}};
    private static final byte[][] OTHER_START = new byte[][]{{60}, {33, 47, 63}};
    private static final byte[][] CHARSET_START = new byte[][]{{99, 67}, {104, 72}, {97, 65}, {114, 82}, {115, 83}, {101, 69}, {116, 84}};
    private static final int SIZE_OF_HTML_CONTENT_SNIFFED = 4096;
    private static final int SIZE_OF_XML_CONTENT_SNIFFED = 512;

    private EncodingSniffer() {
    }

    public static String sniffEncoding(List<NameValuePair> headers, InputStream content) throws IOException {
        if (EncodingSniffer.isHtml(headers)) {
            return EncodingSniffer.sniffHtmlEncoding(headers, content);
        }
        if (EncodingSniffer.isXml(headers)) {
            return EncodingSniffer.sniffXmlEncoding(headers, content);
        }
        return EncodingSniffer.sniffUnknownContentTypeEncoding(headers, content);
    }

    static boolean isHtml(List<NameValuePair> headers) {
        return EncodingSniffer.contentTypeEndsWith(headers, "text/html");
    }

    static boolean isXml(List<NameValuePair> headers) {
        return EncodingSniffer.contentTypeEndsWith(headers, "text/xml", "application/xml", "text/vnd.wap.wml", "+xml");
    }

    static boolean contentTypeEndsWith(List<NameValuePair> headers, String ... contentTypeEndings) {
        for (NameValuePair pair : headers) {
            String name = pair.getName();
            if (!"content-type".equalsIgnoreCase(name)) continue;
            String value = pair.getValue();
            int i = value.indexOf(59);
            if (i != -1) {
                value = value.substring(0, i);
            }
            value = value.trim();
            boolean found = false;
            for (String ending : contentTypeEndings) {
                if (!value.toLowerCase().endsWith(ending.toLowerCase())) continue;
                found = true;
                break;
            }
            return found;
        }
        return false;
    }

    public static String sniffHtmlEncoding(List<NameValuePair> headers, InputStream content) throws IOException {
        String encoding = EncodingSniffer.sniffEncodingFromHttpHeaders(headers);
        if (encoding != null || content == null) {
            return encoding;
        }
        byte[] bytes = EncodingSniffer.read(content, 3);
        encoding = EncodingSniffer.sniffEncodingFromUnicodeBom(bytes);
        if (encoding != null) {
            return encoding;
        }
        bytes = EncodingSniffer.readAndPrepend(content, 4096, bytes);
        encoding = EncodingSniffer.sniffEncodingFromMetaTag(bytes);
        return encoding;
    }

    public static String sniffXmlEncoding(List<NameValuePair> headers, InputStream content) throws IOException {
        String encoding = EncodingSniffer.sniffEncodingFromHttpHeaders(headers);
        if (encoding != null || content == null) {
            return encoding;
        }
        byte[] bytes = EncodingSniffer.read(content, 3);
        encoding = EncodingSniffer.sniffEncodingFromUnicodeBom(bytes);
        if (encoding != null) {
            return encoding;
        }
        bytes = EncodingSniffer.readAndPrepend(content, 512, bytes);
        encoding = EncodingSniffer.sniffEncodingFromXmlDeclaration(bytes);
        return encoding;
    }

    public static String sniffUnknownContentTypeEncoding(List<NameValuePair> headers, InputStream content) throws IOException {
        String encoding = EncodingSniffer.sniffEncodingFromHttpHeaders(headers);
        if (encoding != null || content == null) {
            return encoding;
        }
        byte[] bytes = EncodingSniffer.read(content, 3);
        encoding = EncodingSniffer.sniffEncodingFromUnicodeBom(bytes);
        return encoding;
    }

    static String sniffEncodingFromHttpHeaders(List<NameValuePair> headers) {
        String encoding = null;
        for (NameValuePair pair : headers) {
            String value;
            String name = pair.getName();
            if (!"content-type".equalsIgnoreCase(name) || (encoding = EncodingSniffer.extractEncodingFromContentType(value = pair.getValue())) == null) continue;
            encoding = encoding.toUpperCase();
            break;
        }
        if (encoding != null && LOG.isDebugEnabled()) {
            LOG.debug("Encoding found in HTTP headers: '" + encoding + "'.");
        }
        return encoding;
    }

    static String sniffEncodingFromUnicodeBom(byte[] bytes) {
        String encoding = null;
        byte[] markerUTF8 = new byte[]{-17, -69, -65};
        byte[] markerUTF16BE = new byte[]{-2, -1};
        byte[] markerUTF16LE = new byte[]{-1, -2};
        if (bytes != null && ArrayUtils.isEquals(markerUTF8, ArrayUtils.subarray(bytes, 0, 3))) {
            encoding = UTF8;
        } else if (bytes != null && ArrayUtils.isEquals(markerUTF16BE, ArrayUtils.subarray(bytes, 0, 2))) {
            encoding = UTF16_BE;
        } else if (bytes != null && ArrayUtils.isEquals(markerUTF16LE, ArrayUtils.subarray(bytes, 0, 2))) {
            encoding = UTF16_LE;
        }
        if (encoding != null && LOG.isDebugEnabled()) {
            LOG.debug("Encoding found in Unicode Byte Order Mark: '" + encoding + "'.");
        }
        return encoding;
    }

    static String sniffEncodingFromMetaTag(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            Attribute att;
            block14: {
                if (EncodingSniffer.matches(bytes, i, COMMENT_START)) {
                    if ((i = EncodingSniffer.indexOfSubArray(bytes, new byte[]{45, 45, 62}, i)) == -1) break;
                    i += 2;
                    continue;
                }
                if (!EncodingSniffer.matches(bytes, i, META_START)) break block14;
                att = EncodingSniffer.getAttribute(bytes, i += META_START.length);
                while (att != null) {
                    block15: {
                        String charset;
                        block17: {
                            String value;
                            String name;
                            block16: {
                                i = att.getUpdatedIndex();
                                name = att.getName();
                                value = att.getValue();
                                if (!"charset".equals(name) && !"content".equals(name)) break block15;
                                charset = null;
                                if (!"charset".equals(name)) break block16;
                                charset = value;
                                break block17;
                            }
                            if ("content".equals(name) && (charset = EncodingSniffer.extractEncodingFromContentType(value)) == null) break block15;
                        }
                        if (UTF16_BE.equalsIgnoreCase(charset) || UTF16_LE.equalsIgnoreCase(charset)) {
                            charset = UTF8;
                        }
                        if (EncodingSniffer.isSupportedCharset(charset)) {
                            charset = charset.toUpperCase();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Encoding found in meta tag: '" + charset + "'.");
                            }
                            return charset;
                        }
                    }
                    att = EncodingSniffer.getAttribute(bytes, i);
                }
                continue;
            }
            if (i + 1 < bytes.length && bytes[i] == 60 && Character.isLetter(bytes[i + 1])) {
                if ((i = EncodingSniffer.skipToAnyOf(bytes, i, new byte[]{9, 10, 12, 13, 32, 62})) == -1) break;
                while ((att = EncodingSniffer.getAttribute(bytes, i)) != null) {
                    i = att.getUpdatedIndex();
                }
                continue;
            }
            if (i + 2 < bytes.length && bytes[i] == 60 && bytes[i + 1] == 47 && Character.isLetter(bytes[i + 2])) {
                Attribute attribute;
                if ((i = EncodingSniffer.skipToAnyOf(bytes, i, new byte[]{9, 10, 12, 13, 32, 62})) == -1) break;
                while ((attribute = EncodingSniffer.getAttribute(bytes, i)) != null) {
                    i = attribute.getUpdatedIndex();
                }
                continue;
            }
            if (EncodingSniffer.matches(bytes, i, OTHER_START) && (i = EncodingSniffer.skipToAnyOf(bytes, i, new byte[]{62})) == -1) break;
        }
        return null;
    }

    static Attribute getAttribute(byte[] bytes, int i) {
        byte b;
        if (i >= bytes.length) {
            return null;
        }
        while (bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 32 || bytes[i] == 47) {
            if (++i < bytes.length) continue;
            return null;
        }
        if (bytes[i] == 62) {
            return null;
        }
        StringBuilder name = new StringBuilder();
        StringBuilder value = new StringBuilder();
        while (true) {
            if (i >= bytes.length) {
                return new Attribute(name.toString(), value.toString(), i);
            }
            if (bytes[i] == 61 && name.length() > 0) {
                ++i;
                break;
            }
            if (bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 32) {
                while (bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 32) {
                    if (++i < bytes.length) continue;
                    return new Attribute(name.toString(), value.toString(), i);
                }
                if (bytes[i] != 61) {
                    return new Attribute(name.toString(), value.toString(), i);
                }
                ++i;
                break;
            }
            if (bytes[i] == 47 || bytes[i] == 62) {
                return new Attribute(name.toString(), value.toString(), i);
            }
            name.append((char)bytes[i]);
            ++i;
        }
        if (i >= bytes.length) {
            return new Attribute(name.toString(), value.toString(), i);
        }
        while (bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 32) {
            if (++i < bytes.length) continue;
            return new Attribute(name.toString(), value.toString(), i);
        }
        if (bytes[i] == 34 || bytes[i] == 39) {
            byte b2 = bytes[i];
            ++i;
            while (i < bytes.length) {
                if (bytes[i] == b2) {
                    return new Attribute(name.toString(), value.toString(), ++i);
                }
                if (bytes[i] >= 65 && bytes[i] <= 90) {
                    byte b22 = (byte)(bytes[i] + 32);
                    value.append((char)b22);
                } else {
                    value.append((char)bytes[i]);
                }
                ++i;
            }
            return new Attribute(name.toString(), value.toString(), i);
        }
        if (bytes[i] == 62) {
            return new Attribute(name.toString(), value.toString(), i);
        }
        if (bytes[i] >= 65 && bytes[i] <= 90) {
            b = (byte)(bytes[i] + 32);
            value.append((char)b);
            ++i;
        } else {
            value.append((char)bytes[i]);
            ++i;
        }
        while (i < bytes.length) {
            if (bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 32 || bytes[i] == 62) {
                return new Attribute(name.toString(), value.toString(), i);
            }
            if (bytes[i] >= 65 && bytes[i] <= 90) {
                b = (byte)(bytes[i] + 32);
                value.append((char)b);
            } else {
                value.append((char)bytes[i]);
            }
            ++i;
        }
        return new Attribute(name.toString(), value.toString(), i);
    }

    static String extractEncodingFromContentType(String s) {
        String charset;
        int i;
        if (s == null) {
            return null;
        }
        byte[] bytes = s.getBytes();
        for (i = 0; i < bytes.length; ++i) {
            if (!EncodingSniffer.matches(bytes, i, CHARSET_START)) continue;
            i += CHARSET_START.length;
            break;
        }
        if (i == bytes.length) {
            return null;
        }
        while (bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 32) {
            if (++i != bytes.length) continue;
            return null;
        }
        if (bytes[i] != 61) {
            return null;
        }
        if (++i == bytes.length) {
            return null;
        }
        while (bytes[i] == 9 || bytes[i] == 10 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 32) {
            if (++i != bytes.length) continue;
            return null;
        }
        if (bytes[i] == 34) {
            if (bytes.length <= i + 1) {
                return null;
            }
            int index = ArrayUtils.indexOf(bytes, (byte)34, i + 1);
            if (index == -1) {
                return null;
            }
            String charset2 = new String(ArrayUtils.subarray(bytes, i + 1, index));
            return EncodingSniffer.isSupportedCharset(charset2) ? charset2 : null;
        }
        if (bytes[i] == 39) {
            if (bytes.length <= i + 1) {
                return null;
            }
            int index = ArrayUtils.indexOf(bytes, (byte)39, i + 1);
            if (index == -1) {
                return null;
            }
            String charset3 = new String(ArrayUtils.subarray(bytes, i + 1, index));
            return EncodingSniffer.isSupportedCharset(charset3) ? charset3 : null;
        }
        int end = EncodingSniffer.skipToAnyOf(bytes, i, new byte[]{9, 10, 12, 13, 32, 59});
        if (end == -1) {
            end = bytes.length;
        }
        return EncodingSniffer.isSupportedCharset(charset = new String(ArrayUtils.subarray(bytes, i, end))) ? charset : null;
    }

    static String sniffEncodingFromXmlDeclaration(byte[] bytes) {
        String declaration;
        int start;
        int index;
        String encoding = null;
        byte[] declarationPrefix = "<?xml ".getBytes();
        if (ArrayUtils.isEquals(declarationPrefix, ArrayUtils.subarray(bytes, 0, declarationPrefix.length)) && (index = ArrayUtils.indexOf(bytes, (byte)63, 2)) + 1 < bytes.length && bytes[index + 1] == 62 && (start = (declaration = new String(bytes, 0, index + 2)).indexOf("encoding")) != -1) {
            char delimiter;
            start += 8;
            block3: while (true) {
                switch (declaration.charAt(start)) {
                    case '\"': 
                    case '\'': {
                        delimiter = declaration.charAt(start);
                        break block3;
                    }
                    default: {
                        ++start;
                        continue block3;
                    }
                }
                break;
            }
            int end = declaration.indexOf(delimiter, ++start);
            encoding = declaration.substring(start, end);
        }
        if (encoding != null && !EncodingSniffer.isSupportedCharset(encoding)) {
            encoding = null;
        }
        if (encoding != null && LOG.isDebugEnabled()) {
            LOG.debug("Encoding found in XML declaration: '" + encoding + "'.");
        }
        return encoding;
    }

    static boolean isSupportedCharset(String charset) {
        try {
            return Charset.isSupported(charset);
        }
        catch (IllegalCharsetNameException e) {
            return false;
        }
    }

    static boolean matches(byte[] bytes, int i, byte[][] sought) {
        if (i + sought.length > bytes.length) {
            return false;
        }
        for (int x = 0; x < sought.length; ++x) {
            byte[] possibilities = sought[x];
            boolean match = false;
            for (int y = 0; y < possibilities.length; ++y) {
                if (bytes[i + x] != possibilities[y]) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    static int skipToAnyOf(byte[] bytes, int i, byte[] targets) {
        while (i < bytes.length && !ArrayUtils.contains(targets, bytes[i])) {
            ++i;
        }
        if (i == bytes.length) {
            i = -1;
        }
        return i;
    }

    static int indexOfSubArray(byte[] array, byte[] subarray, int startIndex) {
        for (int i = startIndex; i < array.length; ++i) {
            boolean found = true;
            if (i + subarray.length > array.length) break;
            for (int j = 0; j < subarray.length; ++j) {
                byte a = array[i + j];
                byte b = subarray[j];
                if (a == b) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    static byte[] read(InputStream content, int size) throws IOException {
        byte[] bytes = new byte[size];
        int count = content.read(bytes);
        if (count == -1) {
            bytes = new byte[]{};
        } else if (count < size) {
            byte[] smaller = new byte[count];
            System.arraycopy(bytes, 0, smaller, 0, count);
            bytes = smaller;
        }
        return bytes;
    }

    static byte[] readAndPrepend(InputStream content, int size, byte[] prefix) throws IOException {
        byte[] bytes = EncodingSniffer.read(content, size);
        byte[] joined = new byte[prefix.length + bytes.length];
        System.arraycopy(prefix, 0, joined, 0, prefix.length);
        System.arraycopy(bytes, 0, joined, prefix.length, bytes.length);
        return joined;
    }

    static class Attribute {
        private final String name_;
        private final String value_;
        private final int updatedIndex_;

        Attribute(String name, String value, int updatedIndex) {
            this.name_ = name;
            this.value_ = value;
            this.updatedIndex_ = updatedIndex;
        }

        String getName() {
            return this.name_;
        }

        String getValue() {
            return this.value_;
        }

        int getUpdatedIndex() {
            return this.updatedIndex_;
        }
    }
}

