/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.mockWebServices;

import fitlibrary.log.FixturingLogger;
import fitlibrary.mockWebServices.logger.MockLogger;
import fitlibrary.mockWebServices.responder.Responder;
import fitlibrary.mockWebServices.term.OrTerm;
import fitlibrary.server.AbstractHttpRequestHandler;
import fitlibrary.ws.message.PostMessage;
import fitlibrary.ws.soap.Soap;
import java.io.IOException;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MockWebServiceHandler
extends AbstractHttpRequestHandler {
    private static Logger logger = FixturingLogger.getLogger(MockWebServiceHandler.class);
    private final OrTerm term;
    private MockLogger logging;
    private int portNo;

    public MockWebServiceHandler(int portNo, OrTerm term, MockLogger logging) {
        this.term = term;
        this.logging = logging;
        this.portNo = portNo;
        Logger.getRootLogger().setLevel(Level.ALL);
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
        if (!method.equals("POST")) {
            throw new MethodNotSupportedException(String.valueOf(method) + " method not supported: only POST supported");
        }
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            this.error(response, 403, "No text/xml provided");
            return;
        }
        String uri = request.getRequestLine().getUri();
        logger.trace((Object)("uri: " + uri));
        HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
        String contentType = entity.getContentType().getValue();
        logger.trace((Object)("Content type: " + contentType));
        this.call(uri, response, entity);
    }

    private void call(String uri, HttpResponse response, HttpEntity entity) throws IOException {
        String requestContent = EntityUtils.toString((HttpEntity)entity);
        logger.trace((Object)("Incoming content: " + requestContent));
        PostMessage request = new PostMessage(uri, requestContent, Soap.decodedType(entity.getContentType().getValue()));
        Responder responder = this.term.matchRequest(request);
        this.logging.responded("Port " + this.portNo, request, responder, this.portNo);
        logger.trace((Object)("Responder result code: " + responder.getResultCode()));
        logger.trace((Object)("Responder Content-Type: " + responder.getContentType()));
        logger.trace((Object)("Responder: " + responder.getContents()));
        EntityTemplate body = this.makeBody(responder.getContents(), responder.getContentType());
        response.setEntity((HttpEntity)body);
        response.setStatusCode(responder.getResultCode());
    }
}

