/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.mockWebServices;

import fitlibrary.log.FitLibraryLogger;
import fitlibrary.mockWebServices.MockingServer;
import fitlibrary.mockWebServices.logger.ClockedLogger;
import fitlibrary.mockWebServices.logger.MockLogger;
import fitlibrary.mockWebServices.term.Term;
import fitlibrary.ws.clock.Clock;
import fitlibrary.ws.clock.RealClock;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MockingWebServices {
    static Logger logger = FitLibraryLogger.getLogger(MockingWebServices.class);
    protected final MockLogger logging;
    private Map<Integer, MockingServer> servers = new HashMap<Integer, MockingServer>();

    public MockingWebServices() {
        this(new RealClock());
    }

    public MockingWebServices(Clock clock) {
        this.logging = new ClockedLogger(clock);
        Logger.getRootLogger().setLevel(Level.ALL);
        logger.trace((Object)"Started MockingWebServices");
    }

    public MockLogger close(int timeout) throws IOException {
        this.sleep(timeout);
        this.closePorts();
        this.sleep(timeout);
        return this.logging;
    }

    private void closePorts() throws IOException {
        for (Integer port : this.servers.keySet()) {
            this.servers.get(port).stop();
        }
        this.servers.clear();
    }

    public void or(int portNo, Term term, boolean insertAtEnd) throws IOException {
        logger.trace((Object)("or " + term));
        MockingServer server = this.servers.get(new Integer(portNo));
        if (server == null) {
            server = new MockingServer(portNo, this.logging);
            this.servers.put(new Integer(portNo), server);
        }
        server.or(term, insertAtEnd);
        logger.trace((Object)(String.valueOf(portNo) + " with " + server.getTerm()));
    }

    private void sleep(int timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

