/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.mockWebServices.transactionFixture;

import fitlibrary.mockWebServices.MockingWebServices;
import fitlibrary.mockWebServices.requestMatcher.NotRequestMatcher;
import fitlibrary.mockWebServices.requestMatcher.XPathMatcher;
import fitlibrary.mockWebServices.requestMatcher.XmlRequestMatcher;
import fitlibrary.mockWebServices.transactionFixture.AbstractTransactionFixture;
import fitlibrary.ws.message.ContentType;
import fitlibrary.ws.soap.Soap;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class Soap12TransactionFixture
extends AbstractTransactionFixture {
    public Soap12TransactionFixture(int port, MockingWebServices mockingWebServices) {
        super(ContentType.SOAP12, port, mockingWebServices);
    }

    public void matchesRequest(String xml) {
        this.requestMatcher = this.requestMatcher.and(new XmlRequestMatcher(Soap.wrap12(xml)));
    }

    public void matchesRequestFromFile(String fileName) throws IOException {
        this.matchesRequest(FileUtils.readFileToString((File)new File(fileName), (String)"utf-8"));
    }

    public void notMatchesRequest(String xml) {
        this.requestMatcher = this.requestMatcher.and(new NotRequestMatcher(new XmlRequestMatcher(Soap.wrap12(xml))));
    }

    public void xpathIs(String xpath, String value) {
        this.requestMatcher = this.requestMatcher.and(new XPathMatcher(xpath, value));
    }

    @Override
    protected String wrapContents(String responseString) {
        return Soap.wrap12(responseString);
    }
}

