/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.server;

import fitlibrary.log.FixturingLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.log4j.Logger;

public abstract class AbstractHttpRequestHandler
implements HttpRequestHandler {
    private static Logger logger = FixturingLogger.getLogger(AbstractHttpRequestHandler.class);

    protected void errorInHtmlH1(HttpResponse response, int status, String error) {
        this.error(response, status, "<html><body><h1>" + error + "</h1></body></html>");
    }

    protected void error(HttpResponse response, int status, String error) {
        response.setStatusCode(status);
        EntityTemplate body = this.makeBody(error, "text/html; charset=UTF-8");
        response.setEntity((HttpEntity)body);
        logger.error((Object)error);
    }

    protected EntityTemplate makeBody(final String contents, String contentType) {
        EntityTemplate body = new EntityTemplate(new ContentProducer(){

            public void writeTo(OutputStream outstream) throws IOException {
                OutputStreamWriter writer = new OutputStreamWriter(outstream, "UTF-8");
                writer.write(contents);
                writer.flush();
            }
        });
        body.setContentType(contentType);
        return body;
    }
}

