/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider;

import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.traverse.Traverse;
import java.util.List;

public class TableFixture
extends Traverse {
    List<List<String>> array;

    public TableFixture(List<List<String>> array) {
        this.array = array;
    }

    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        try {
            int rowNo = 1;
            while (rowNo < table.size() && rowNo < this.array.size() + 1) {
                this.matchRow((Row)table.at(rowNo), this.array.get(rowNo - 1), testResults);
                ++rowNo;
            }
            this.missingActualRows(table, testResults);
            this.missingExpectedRows(table, testResults);
        }
        catch (Exception e) {
            table.error(testResults, (Throwable)e);
        }
        return null;
    }

    private void missingActualRows(Table table, TestResults testResults) {
        int rowNo = this.array.size() + 1;
        while (rowNo < table.size()) {
            Row expectedRow = (Row)table.at(rowNo);
            int colNo = 0;
            while (colNo < expectedRow.size()) {
                ((Cell)expectedRow.at(colNo)).actualElementMissing(testResults);
                ++colNo;
            }
            ++rowNo;
        }
    }

    private void missingExpectedRows(Table table, TestResults testResults) {
        int rowNo = table.size();
        while (rowNo < this.array.size() + 1) {
            List<String> actualRow = this.array.get(rowNo - 1);
            Row newRow = table.newRow();
            int colNo = 0;
            while (colNo < actualRow.size()) {
                Cell cell = TableFactory.cell((String)actualRow.get(colNo).toString());
                newRow.add((Object)cell);
                cell.actualElementMissing(testResults);
                ++colNo;
            }
            ++rowNo;
        }
    }

    private void matchRow(Row expectedRow, List<String> actualRow, TestResults testResults) {
        int colNo = 0;
        while (colNo < expectedRow.size() && colNo < actualRow.size()) {
            Cell cell = (Cell)expectedRow.at(colNo);
            String expectedText = (String)this.resolve((String)cell.text()).first;
            String actualText = actualRow.get(colNo);
            if (expectedText.equals(actualText)) {
                cell.pass(testResults);
            } else {
                cell.fail(testResults, actualText, (VariableResolver)this);
            }
            ++colNo;
        }
        this.missingActualCellValues(expectedRow, actualRow, testResults);
        this.missingExpectedCellValues(expectedRow, actualRow, testResults);
    }

    private void missingExpectedCellValues(Row expectedRow, List<String> actualRow, TestResults testResults) {
        int colNo = expectedRow.size();
        while (colNo < actualRow.size()) {
            Cell cell = TableFactory.cell((String)actualRow.get(colNo));
            expectedRow.add((Object)cell);
            cell.actualElementMissing(testResults);
            ++colNo;
        }
    }

    private void missingActualCellValues(Row expectedRow, List<String> actualRow, TestResults testResults) {
        int colNo = actualRow.size();
        while (colNo < expectedRow.size()) {
            ((Cell)expectedRow.at(colNo)).actualElementMissing(testResults);
            ++colNo;
        }
    }
}

