/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider.driver;

import fitlibrary.differences.LocalFile;
import fitlibrary.spider.AbstractSpiderFixture;
import fitlibrary.spider.driver.DriverVariation;
import fitlibrary.spider.polling.PollForNoException;
import org.openqa.selenium.firefox.FirefoxDriver;

public class FirefoxVariation
extends DriverVariation {
    private final FirefoxDriver firefoxDriver;

    public FirefoxVariation(AbstractSpiderFixture spiderFixture, FirefoxDriver firefoxDriver) {
        super(spiderFixture);
        this.firefoxDriver = firefoxDriver;
    }

    @Override
    public void checkTitleOfNewPage(final String url) throws Exception {
        this.spiderFixture.ensureNoException(new PollForNoException<Boolean>(){

            @Override
            public Boolean act() {
                if (FirefoxVariation.this.spiderFixture.getTitle() != null) {
                    return true;
                }
                throw FirefoxVariation.this.spiderFixture.problem("Unable to access", url);
            }
        });
    }

    @Override
    public boolean close() {
        boolean result = super.close();
        try {
            this.spiderFixture.selectInitialWindow();
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void screenDump() {
        LocalFile file = this.pngFile();
        this.firefoxDriver.saveScreenshot(file.getFile());
        this.spiderFixture.showAfterTable(file.htmlImageLink());
    }

    @Override
    public void screenDump(String fileName) {
        LocalFile file = this.pngFile(fileName);
        this.firefoxDriver.saveScreenshot(file.getFile());
        this.spiderFixture.showAfterTable(file.htmlImageLink());
    }
}

