/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider.element;

import fitlibrary.log.FixturingLogger;
import fitlibrary.spider.AbstractSpiderFixture;
import fitlibrary.spider.element.SpiderElement;
import fitlibrary.spider.element.SpiderWebElement;
import fitlibrary.spider.polling.PollForMatches;
import fitlibrary.spider.polling.PollForWithError;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class SelectElement
extends SpiderElement {
    static Logger logger = FixturingLogger.getLogger(SelectElement.class);

    public SelectElement(AbstractSpiderFixture spiderFixture) {
        super(spiderFixture);
    }

    private Select webDriverSelect(String locator) {
        return new Select(this.findElement(locator));
    }

    protected List<WebElement> childrenOf(String locator) {
        return this.webDriverSelect(locator).getOptions();
    }

    public String optionOf(String locator) {
        List<WebElement> childrenOf = this.childrenOf(locator);
        for (WebElement option : childrenOf) {
            if (!option.isSelected()) continue;
            String value = option.getAttribute("value");
            return value == null || value.length() == 0 ? option.getText() : value;
        }
        return "";
    }

    public List<String> optionListOf(String locator) {
        ArrayList<String> result = new ArrayList<String>();
        for (WebElement option : this.childrenOf(locator)) {
            if (!option.isSelected()) continue;
            result.add(option.getAttribute("value"));
        }
        return result;
    }

    public boolean optionallyWithSelectOption(String locator, String option) {
        block3: {
            if (!"".equals(option)) break block3;
            return true;
        }
        try {
            this.withSelectOption(locator, option);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean withSelectOption(String locator, String option) {
        return this.selectOption(locator, option, true);
    }

    public boolean withSelectText(String locator, String text) {
        return this.selectTextThroughChildren(locator, text);
    }

    public boolean withSelectOptionAt(String locator, int index) {
        try {
            final WebElement webElement = this.childrenOf(locator).get(index);
            this.setSelected(webElement);
            this.ensureBecomes(new PollForWithError(){

                @Override
                public boolean matches() {
                    return webElement.isSelected();
                }

                @Override
                public String error() {
                    return "Not selected correctly";
                }
            });
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean withAddSelection(String locator, String option) {
        return this.selectOption(locator, option, true);
    }

    public boolean withRemoveSelection(String locator, String option) {
        return this.selectOption(locator, option, false);
    }

    private boolean selectOption(String locator, String option, boolean select) {
        return this.selectOptionThroughChildren(locator, option, select);
    }

    private boolean selectOptionThroughChildren(final String locator, final String option, final boolean select) {
        return this.ensureMatches(new PollForMatches(){

            @Override
            public boolean matches() {
                List<WebElement> childrenOf = SelectElement.this.childrenOf(locator);
                for (WebElement optionElement : childrenOf) {
                    String value = optionElement.getAttribute("value");
                    if ((value == null || value.length() == 0) && option.length() > 0) {
                        value = optionElement.getText();
                    }
                    if (value == null || !value.equalsIgnoreCase(option)) continue;
                    if (select != optionElement.isSelected()) {
                        if (select) {
                            SelectElement.this.setSelected(optionElement);
                        } else {
                            SelectElement.this.toggle(optionElement);
                        }
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private void toggle(WebElement e) {
        e.click();
    }

    private void setSelected(WebElement e) {
        if (e.isSelected()) {
            return;
        }
        this.toggle(e);
    }

    private boolean selectTextThroughChildren(final String locator, final String textRequired) {
        return this.ensureMatches(new PollForMatches(){

            @Override
            public boolean matches() {
                for (WebElement optionElement : SelectElement.this.childrenOf(locator)) {
                    String text = optionElement.getText();
                    if (text == null || !text.equalsIgnoreCase(textRequired)) continue;
                    SelectElement.this.setSelected(optionElement);
                    return true;
                }
                return false;
            }
        });
    }

    public List<String> optionValues(String locator) {
        ArrayList<String> nameList = new ArrayList<String>();
        List<SpiderWebElement> options = this.options(locator);
        for (SpiderWebElement option : options) {
            nameList.add(option.getValue());
        }
        return nameList;
    }

    public List<SpiderWebElement> options(String locator) {
        String rawHtmlOfParent = this.spiderFixture().innerHtmlOf(locator);
        ArrayList<SpiderWebElement> elements = new ArrayList<SpiderWebElement>();
        for (WebElement webDriversElement : this.childrenOf(locator)) {
            elements.add(new SpiderWebElement(webDriversElement, rawHtmlOfParent));
        }
        return elements;
    }
}

