/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ws.mock.requestMatcher;

import fitlibrary.mockWebServices.requestMatcher.AndRequestMatcher;
import fitlibrary.mockWebServices.requestMatcher.RequestMatcher;
import fitlibrary.ws.message.Message;
import fitlibrary.ws.message.ReplyMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestAndRequestMatcher {
    Mockery context = new JUnit4Mockery();
    final RequestMatcher first = (RequestMatcher)this.context.mock(RequestMatcher.class, "first");
    final RequestMatcher second = (RequestMatcher)this.context.mock(RequestMatcher.class, "second");
    private RequestMatcher matcher = new AndRequestMatcher(this.first, this.second);
    protected final Message request = TestAndRequestMatcher.msg("any string");

    @Test
    public void matchTrueTrue() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestAndRequestMatcher.this.first)).match(TestAndRequestMatcher.this.request);
                this.will(1.returnValue((Object)true));
                ((RequestMatcher)this.one(TestAndRequestMatcher.this.second)).match(TestAndRequestMatcher.this.request);
                this.will(1.returnValue((Object)true));
            }
        });
        Assert.assertThat((Object)this.matcher.match(TestAndRequestMatcher.msg("any string")), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void matchFalseTrue() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestAndRequestMatcher.this.first)).match(TestAndRequestMatcher.this.request);
                this.will(2.returnValue((Object)false));
            }
        });
        Assert.assertThat((Object)this.matcher.match(TestAndRequestMatcher.msg("any string")), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void matchTrueFalse() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestAndRequestMatcher.this.first)).match(TestAndRequestMatcher.this.request);
                this.will(3.returnValue((Object)true));
                ((RequestMatcher)this.one(TestAndRequestMatcher.this.second)).match(TestAndRequestMatcher.this.request);
                this.will(3.returnValue((Object)false));
            }
        });
        Assert.assertThat((Object)this.matcher.match(this.request), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void matchFalseFalse() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestAndRequestMatcher.this.first)).match(TestAndRequestMatcher.this.request);
                this.will(4.returnValue((Object)false));
            }
        });
        Assert.assertThat((Object)this.matcher.match(this.request), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void and() throws Exception {
        final RequestMatcher requestMatcher = (RequestMatcher)this.context.mock(RequestMatcher.class, "third");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestAndRequestMatcher.this.first)).match(TestAndRequestMatcher.this.request);
                this.will(5.returnValue((Object)true));
                ((RequestMatcher)this.one(TestAndRequestMatcher.this.second)).match(TestAndRequestMatcher.this.request);
                this.will(5.returnValue((Object)true));
                ((RequestMatcher)this.one(requestMatcher)).match(TestAndRequestMatcher.this.request);
                this.will(5.returnValue((Object)true));
            }
        });
        Assert.assertThat((Object)this.matcher.and(requestMatcher).match(this.request), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void or() throws Exception {
        final RequestMatcher requestMatcher = (RequestMatcher)this.context.mock(RequestMatcher.class, "third");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestAndRequestMatcher.this.first)).match(TestAndRequestMatcher.this.request);
                this.will(6.returnValue((Object)true));
                ((RequestMatcher)this.one(TestAndRequestMatcher.this.second)).match(TestAndRequestMatcher.this.request);
                this.will(6.returnValue((Object)false));
                ((RequestMatcher)this.one(requestMatcher)).match(TestAndRequestMatcher.this.request);
                this.will(6.returnValue((Object)true));
            }
        });
        Assert.assertThat((Object)this.matcher.or(requestMatcher).match(this.request), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void notFalse() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestAndRequestMatcher.this.first)).match(TestAndRequestMatcher.this.request);
                this.will(7.returnValue((Object)true));
                ((RequestMatcher)this.one(TestAndRequestMatcher.this.second)).match(TestAndRequestMatcher.this.request);
                this.will(7.returnValue((Object)false));
            }
        });
        Assert.assertThat((Object)this.matcher.not().match(this.request), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void notTrue() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestAndRequestMatcher.this.first)).match(TestAndRequestMatcher.this.request);
                this.will(8.returnValue((Object)true));
                ((RequestMatcher)this.one(TestAndRequestMatcher.this.second)).match(TestAndRequestMatcher.this.request);
                this.will(8.returnValue((Object)true));
            }
        });
        Assert.assertThat((Object)this.matcher.not().match(this.request), (Matcher)Matchers.equalTo((Object)false));
    }

    private static ReplyMessage msg(String string) {
        return new ReplyMessage(string);
    }
}

