/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ws.mock.term;

import fitlibrary.mockWebServices.logger.MockLogger;
import fitlibrary.mockWebServices.requestMatcher.RequestMatcher;
import fitlibrary.mockWebServices.responder.LiteralResponder;
import fitlibrary.mockWebServices.responder.Responder;
import fitlibrary.mockWebServices.term.CompositeTerm;
import fitlibrary.mockWebServices.term.LeafTerm;
import fitlibrary.mockWebServices.term.SequentialTerm;
import fitlibrary.mockWebServices.term.Term;
import fitlibrary.ws.message.ContentType;
import fitlibrary.ws.message.Message;
import fitlibrary.ws.message.ReplyMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestLeafTerm {
    final Mockery context = new JUnit4Mockery();
    final RequestMatcher matcher = (RequestMatcher)this.context.mock(RequestMatcher.class);
    final Responder responder = new LiteralResponder("aa", ContentType.PLAIN);
    final Message request = TestLeafTerm.msg("request");
    final Term t1 = new LeafTerm(this.matcher, this.responder);
    final Term t2 = (Term)this.context.mock(Term.class, "term2");
    final MockLogger logger = (MockLogger)this.context.mock(MockLogger.class);

    @Test
    public void initialState() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestLeafTerm.this.matcher)).getExpected();
                this.will(1.returnValue((Object)"UNUSED"));
                ((MockLogger)this.one(TestLeafTerm.this.logger)).unused(1, "UNUSED");
            }
        });
        Assert.assertThat((Object)this.t1.available(), (Matcher)Matchers.equalTo((Object)true));
        this.t1.logUnused(1, this.logger);
    }

    @Test
    public void used() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestLeafTerm.this.matcher)).match(TestLeafTerm.this.request);
                this.will(2.returnValue((Object)true));
            }
        });
        Assert.assertThat((Object)this.t1.matchRequest(this.request), (Matcher)Matchers.equalTo((Object)this.responder));
        Assert.assertThat((Object)this.t1.available(), (Matcher)Matchers.equalTo((Object)false));
        this.t1.logUnused(1, this.logger);
    }

    @Test(expected=RuntimeException.class)
    public void termCanOnlyBeInOneCompositeSoAsToAvoidDeadlock() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Term)this.one(TestLeafTerm.this.t2)).setComposite((Term)this.with(3.any(CompositeTerm.class)));
            }
        });
        this.term(this.t1, this.t2);
        this.term(this.t1, this.t2);
    }

    private Term term(Term term, Term term2) {
        return new SequentialTerm(term, term2);
    }

    private static ReplyMessage msg(String string) {
        return new ReplyMessage(string);
    }
}

