/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.logging;

import java.io.PrintStream;
import org.firebirdsql.logging.Logger;

public class ConsoleLogger
extends Logger {
    private static final boolean debugEnabled = false;
    private static final boolean infoEnabled = true;
    private static final boolean warnEnabled = true;
    private static final boolean errEnabled = true;
    private static final boolean fatalEnabled = true;
    private String name;

    public ConsoleLogger(String name) {
        this.name = name;
    }

    public boolean isDebugEnabled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void out(Object message, Throwable t) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println("[" + this.name + "]" + message);
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void err(Object message, Throwable t) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.err.println("[" + this.name + "]" + message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    public void debug(Object message) {
        this.debug(message, null);
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.out(message, t);
        }
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(Object message) {
        this.info(message, null);
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.out(message, t);
        }
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(Object message) {
        this.warn(message, null);
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.err(message, t);
        }
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(Object message) {
        this.error(message, null);
    }

    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.err(message, t);
        }
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public void fatal(Object message) {
        this.fatal(message, null);
    }

    public void fatal(Object message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.err(message, t);
        }
    }
}

