/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Map;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.Type1;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.gui.ShowGUIMessage;

public class T1Glyphs
extends PdfJavaGlyphs {
    private static String nybChars = "0123456789.ee -";
    public boolean is1C = false;
    protected Map charStrings = new Hashtable();
    int max = 100;
    double[] operandsRead = new double[this.max];
    int operandReached = 0;
    float[] pt;
    private double xs = -1.0;
    private double ys = -1.0;
    private double x = 0.0;
    private double y = 0.0;
    private int ptCount = 0;
    int currentOp = 0;
    private int hintCount = 0;
    private static String[] raw1ByteValues = new String[]{"version", "Notice", "FullName", "FamilyName", "Weight", "FontBBox", "BlueValues", "OtherBlues", "FamilyBlues", "FamilyOtherBlues", "StdHW", "StdVW", "escape", "UniqueID", "XUID", "charset", "Encoding", "CharStrings", "Private", "Subrs", "defaultWidthX", "nominalWidthX", "-Reserved-", "-Reserved-", "-Reserved-", "-Reserved-", "-Reserved-", "-Reserved-", "intint", "longint", "BCD", "-Reserved-"};
    private static String[] raw2ByteValues = new String[]{"Copyright", "isFixedPitch", "ItalicAngle", "UnderlinePosition", "UnderlineThickness", "PaintType", "CharstringType", "FontMatrix", "StrokeWidth", "BlueScale", "BlueShift", "BlueFuzz", "StemSnapH", "StemSnapV", "ForceBold", "-Reserved-", "-Reserved-", "LanguageGroup", "ExpansionFactor", "initialRandomSeed", "SyntheticBase", "PostScript", "BaseFontName", "BaseFontBlend", "-Reserved-", "-Reserved-", "-Reserved-", "-Reserved-", "-Reserved-", "-Reserved-", "ROS", "CIDFontVersion", "CIDFontRevision", "CIDFontType", "CIDCount", "UIDBase", "FDArray", "FDSelect", "FontName"};
    private boolean allowAll = false;
    private double h;
    private boolean isCID;

    public T1Glyphs(boolean bl) {
        this.isCID = bl;
    }

    private boolean processFlex(GlyphFactory glyphFactory, boolean bl, int n, boolean bl2, int n2) {
        if (bl2 && this.ptCount == 14 && n2 == 0) {
            bl2 = false;
            for (int i = 0; i < 12; i += 6) {
                glyphFactory.curveTo(this.pt[i], this.pt[i + 1], this.pt[i + 2], this.pt[i + 3], this.pt[i + 4], this.pt[i + 5]);
                if (!bl) continue;
                System.out.println("t1 flex " + this.pt[i] + " " + this.pt[i + 1] + " " + this.pt[i + 2] + " " + this.pt[i + 3] + " " + this.pt[i + 4] + " " + this.pt[i + 5]);
            }
        } else if (!bl2 && n2 >= 0 && n2 <= 2) {
            bl2 = true;
            this.ptCount = 0;
            this.pt = new float[16];
            if (bl) {
                System.out.println("flex on " + n);
            }
        }
        return bl2;
    }

    private int endchar(GlyphFactory glyphFactory, int n, boolean bl, int n2) {
        if (bl) {
            System.out.println("Endchar");
        }
        if (this.operandReached == 5) {
            --this.operandReached;
            ++this.currentOp;
        }
        if (this.operandReached == 4) {
            this.endchar(glyphFactory, n);
        } else {
            glyphFactory.closePath();
        }
        int n3 = n2;
        return n3;
    }

    private int mask(boolean bl, int n, int n2) {
        if (bl) {
            System.out.println("hintmask/cntrmask " + n2);
        }
        this.hintCount += this.operandReached / 2;
        if (bl) {
            System.out.println("hintCount=" + this.hintCount);
        }
        for (int i = this.hintCount; i > 0; i -= 8) {
            ++n;
        }
        return n;
    }

    private double sbw(boolean bl) {
        double d;
        this.y = d = this.operandsRead[this.operandReached - 2];
        this.xs = this.x = (d = this.operandsRead[this.operandReached - 1]);
        this.ys = this.y;
        this.allowAll = true;
        double d2 = this.y;
        this.h = this.operandsRead[this.operandReached - 3];
        if (bl) {
            System.out.println("sbw xs,ys set to " + this.x + " " + this.y);
        }
        return d2;
    }

    private void hmoveto(GlyphFactory glyphFactory, boolean bl, boolean bl2) {
        if (bl2 && this.operandReached == 2) {
            ++this.currentOp;
        }
        double d = this.operandsRead[this.currentOp];
        this.x += d;
        glyphFactory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
        if (bl) {
            System.out.println("reset xs,ys to " + this.x + " " + this.y);
        }
        if (bl) {
            System.out.println("hmoveto " + this.x + " " + this.y);
        }
    }

    private void rmoveto(GlyphFactory glyphFactory, boolean bl, boolean bl2) {
        if (bl2 && this.operandReached == 3) {
            ++this.currentOp;
        }
        if (bl) {
            System.out.println(this.currentOp + " " + this.operandReached + " " + bl2 + " x,y=(" + this.x + " " + this.y + ") xs,ys=(" + this.xs + " " + this.ys + ") rmoveto " + this.operandsRead[this.currentOp] + " " + this.operandsRead[this.currentOp + 1]);
        }
        double d = this.operandsRead[this.currentOp + 1];
        this.y += d;
        d = this.operandsRead[this.currentOp];
        this.x += d;
        glyphFactory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
        if (bl) {
            System.out.println("xs,ys=(" + this.xs + " " + this.ys + ") x=" + this.x + " y=" + this.y);
        }
    }

    private void vhhvcurveto(GlyphFactory glyphFactory, boolean bl, int n) {
        boolean bl2;
        boolean bl3 = bl2 = n == 31;
        while (this.operandReached >= 4) {
            this.operandReached -= 4;
            if (bl2) {
                this.x += this.operandsRead[this.currentOp];
            } else {
                this.y += this.operandsRead[this.currentOp];
            }
            this.pt[0] = (float)this.x;
            this.pt[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 1];
            this.y += this.operandsRead[this.currentOp + 2];
            this.pt[2] = (float)this.x;
            this.pt[3] = (float)this.y;
            if (bl2) {
                this.y += this.operandsRead[this.currentOp + 3];
                if (this.operandReached == 1) {
                    this.x += this.operandsRead[this.currentOp + 4];
                }
            } else {
                this.x += this.operandsRead[this.currentOp + 3];
                if (this.operandReached == 1) {
                    this.y += this.operandsRead[this.currentOp + 4];
                }
            }
            this.pt[4] = (float)this.x;
            this.pt[5] = (float)this.y;
            glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
            if (bl) {
                System.out.println(this.currentOp + "vh/hvCurveto " + this.operandsRead[this.currentOp] + " " + this.operandsRead[this.currentOp + 1] + " " + this.operandsRead[this.currentOp + 2] + " " + this.operandsRead[this.currentOp + 3] + " " + this.operandsRead[this.currentOp + 4] + " " + this.operandsRead[this.currentOp + 5]);
            }
            this.currentOp += 4;
            bl2 = !bl2;
        }
    }

    private void vvhhcurveto(GlyphFactory glyphFactory, boolean bl, int n) {
        boolean bl2;
        boolean bl3 = bl2 = n == 26;
        if ((this.operandReached & 1) == 1) {
            if (bl2) {
                this.x += this.operandsRead[0];
            } else {
                this.y += this.operandsRead[0];
            }
            ++this.currentOp;
        }
        while (this.currentOp < this.operandReached) {
            if (bl2) {
                this.y += this.operandsRead[this.currentOp];
            } else {
                this.x += this.operandsRead[this.currentOp];
            }
            this.pt[0] = (float)this.x;
            this.pt[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 1];
            this.y += this.operandsRead[this.currentOp + 2];
            this.pt[2] = (float)this.x;
            this.pt[3] = (float)this.y;
            if (bl2) {
                this.y += this.operandsRead[this.currentOp + 3];
            } else {
                this.x += this.operandsRead[this.currentOp + 3];
            }
            this.pt[4] = (float)this.x;
            this.pt[5] = (float)this.y;
            this.currentOp += 4;
            glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
            if (!bl) continue;
            System.out.println("vv/hhCurveto " + this.operandsRead[0] + " " + this.operandsRead[1] + " " + this.operandsRead[2] + " " + this.operandsRead[3] + " " + this.operandsRead[4] + " " + this.operandsRead[5]);
        }
    }

    private void rlinecurve(GlyphFactory glyphFactory, boolean bl) {
        for (int i = (this.operandReached - 6) / 2; i > 0; --i) {
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            glyphFactory.lineTo((float)this.x, (float)this.y);
            if (bl) {
                System.out.println("rlineCurve " + this.operandsRead[0] + " " + this.operandsRead[1]);
            }
            this.currentOp += 2;
        }
        float[] fArray = new float[6];
        this.x += this.operandsRead[this.currentOp];
        this.y += this.operandsRead[this.currentOp + 1];
        fArray[0] = (float)this.x;
        fArray[1] = (float)this.y;
        this.x += this.operandsRead[this.currentOp + 2];
        this.y += this.operandsRead[this.currentOp + 3];
        fArray[2] = (float)this.x;
        fArray[3] = (float)this.y;
        this.x += this.operandsRead[this.currentOp + 4];
        this.y += this.operandsRead[this.currentOp + 5];
        fArray[4] = (float)this.x;
        fArray[5] = (float)this.y;
        glyphFactory.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
        if (bl) {
            System.out.println("rlineCurve " + this.operandsRead[0] + " " + this.operandsRead[1] + " " + this.operandsRead[2] + " " + this.operandsRead[3] + " " + this.operandsRead[4] + " " + this.operandsRead[5]);
        }
        this.currentOp += 6;
    }

    private void closepath(GlyphFactory glyphFactory, boolean bl) {
        if (this.xs != -1.0) {
            glyphFactory.lineTo((float)this.xs, (float)this.ys);
        }
        if (bl) {
            System.out.println("close to xs=" + this.xs + " ys=" + this.ys + " " + this.x + "," + this.y);
        }
        this.xs = -1.0;
    }

    private void hsbw(GlyphFactory glyphFactory, boolean bl) {
        this.x += this.operandsRead[0];
        glyphFactory.moveTo((float)this.x, 0.0f);
        if (bl) {
            System.out.println("hsbw " + this.x + " xs,ys=" + this.xs + " " + this.ys);
        }
        this.allowAll = true;
    }

    private void pop(boolean bl) {
        if (this.operandReached > 0) {
            --this.operandReached;
        }
        if (bl) {
            System.out.println("POP");
        }
        if (bl) {
            for (int i = 0; i < 6; ++i) {
                System.out.println(i + " == " + this.operandsRead[i] + " " + this.operandReached);
            }
        }
    }

    private void setcurrentpoint(boolean bl) {
        if (bl) {
            System.out.println("setCurrentPoint " + this.operandsRead[0] + " " + this.operandsRead[1]);
        }
    }

    private void div(boolean bl) {
        if (bl) {
            for (int i = 0; i < 6; ++i) {
                System.out.println(i + " " + this.currentOp + " " + this.operandsRead[i] + " " + this.operandReached);
            }
        }
        double d = this.operandsRead[this.operandReached - 2] / this.operandsRead[this.operandReached - 1];
        if (this.operandReached > 0) {
            --this.operandReached;
        }
        this.operandsRead[this.operandReached - 1] = d;
        if (bl) {
            for (int i = 0; i < 6; ++i) {
                System.out.println("after====" + i + " == " + this.operandsRead[i] + " " + this.operandReached);
            }
        }
        if (bl) {
            System.out.println("DIV");
        }
    }

    private void vmoveto(GlyphFactory glyphFactory, boolean bl, boolean bl2) {
        if (bl2 && this.operandReached == 2) {
            ++this.currentOp;
        }
        this.y += this.operandsRead[this.currentOp];
        glyphFactory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
        if (bl) {
            System.out.println("Set xs,ys= " + this.xs + " " + this.ys);
        }
        if (bl) {
            System.out.println("vmoveto " + this.operandsRead[0] + " " + this.operandsRead[1] + " currentOp" + this.currentOp + " y=" + this.y + " " + bl2);
        }
    }

    private void rlineto(GlyphFactory glyphFactory, boolean bl) {
        for (int i = this.operandReached / 2; i > 0; --i) {
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            glyphFactory.lineTo((float)this.x, (float)this.y);
            this.currentOp += 2;
            if (!bl) continue;
            System.out.println("x,y= (" + this.x + " " + this.y + ") rlineto " + this.operandsRead[0] + " " + this.operandsRead[1]);
        }
    }

    private void hvlineto(GlyphFactory glyphFactory, boolean bl, int n) {
        boolean bl2 = n == 6;
        for (int i = 0; i < this.operandReached; ++i) {
            if (bl2) {
                this.x += this.operandsRead[i];
            } else {
                this.y += this.operandsRead[i];
            }
            glyphFactory.lineTo((float)this.x, (float)this.y);
            if (bl) {
                System.out.println("h/vlineto " + this.operandsRead[0] + " " + this.operandsRead[1]);
            }
            bl2 = !bl2;
        }
    }

    private void rrcurveto(GlyphFactory glyphFactory, boolean bl) {
        int n = this.operandReached / 6;
        if (bl && n > 1) {
            System.out.println("**********currentOp=" + this.currentOp + " curves=" + n);
        }
        while (n > 0) {
            float[] fArray = new float[6];
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            fArray[0] = (float)this.x;
            fArray[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 2];
            this.y += this.operandsRead[this.currentOp + 3];
            fArray[2] = (float)this.x;
            fArray[3] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 4];
            this.y += this.operandsRead[this.currentOp + 5];
            fArray[4] = (float)this.x;
            fArray[5] = (float)this.y;
            glyphFactory.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
            if (bl) {
                System.out.println("rrcurveto " + this.operandsRead[this.currentOp] + " " + this.operandsRead[this.currentOp + 1] + " " + this.operandsRead[this.currentOp + 2] + " " + this.operandsRead[this.currentOp + 3] + " " + this.operandsRead[this.currentOp + 4] + " " + this.operandsRead[this.currentOp + 5]);
            }
            this.currentOp += 6;
            --n;
        }
    }

    private void endchar(GlyphFactory glyphFactory, int n) {
        StandardFonts.checkLoaded(1);
        float f = (float)(this.x + this.operandsRead[this.currentOp]);
        float f2 = (float)(this.y + this.operandsRead[this.currentOp + 1]);
        String string = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[this.currentOp + 2]);
        String string2 = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[this.currentOp + 3]);
        this.x = 0.0;
        this.y = 0.0;
        this.getGlyph(null, glyphFactory, string, n, "", 0.0f, true);
        glyphFactory.closePath();
        glyphFactory.moveTo(f, f2);
        this.x = f;
        this.y = f2;
        this.getGlyph(null, glyphFactory, string2, n, "", 0.0f, true);
        if (this.xs == -1.0) {
            this.xs = this.x;
            this.ys = this.y;
            System.out.println("ENDCHAR Set xs,ys= " + this.xs + " " + this.ys);
        }
    }

    private void rcurveline(GlyphFactory glyphFactory, boolean bl) {
        for (int i = (this.operandReached - 2) / 6; i > 0; --i) {
            float[] fArray = new float[6];
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            fArray[0] = (float)this.x;
            fArray[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 2];
            this.y += this.operandsRead[this.currentOp + 3];
            fArray[2] = (float)this.x;
            fArray[3] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 4];
            this.y += this.operandsRead[this.currentOp + 5];
            fArray[4] = (float)this.x;
            fArray[5] = (float)this.y;
            glyphFactory.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
            if (bl) {
                System.out.println("rCurveline " + this.operandsRead[0] + " " + this.operandsRead[1] + " " + this.operandsRead[2] + " " + this.operandsRead[3] + " " + this.operandsRead[4] + " " + this.operandsRead[5]);
            }
            this.currentOp += 6;
        }
        this.x += this.operandsRead[this.currentOp];
        this.y += this.operandsRead[this.currentOp + 1];
        glyphFactory.lineTo((float)this.x, (float)this.y);
        this.currentOp += 2;
        if (bl) {
            System.out.println("rCurveline " + this.operandsRead[0] + " " + this.operandsRead[1]);
        }
    }

    private void seac(GlyphFactory glyphFactory, int n, int n2) {
        StandardFonts.checkLoaded(1);
        float f = (float)this.operandsRead[n2 + 1];
        float f2 = (float)this.operandsRead[n2 + 2];
        String string = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[n2 + 3]);
        String string2 = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[n2 + 4]);
        this.x = 0.0;
        this.y = 0.0;
        this.getGlyph(null, glyphFactory, string, n, "", 0.0f, true);
        glyphFactory.closePath();
        glyphFactory.moveTo(0.0f, 0.0f);
        this.x = f;
        this.y = f2;
        this.getGlyph(null, glyphFactory, string2, n, "", 0.0f, true);
    }

    private void flex1(GlyphFactory glyphFactory, boolean bl) {
        int n;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.x;
        double d4 = this.y;
        for (n2 = 0; n2 < 10; n2 += 2) {
            d += this.operandsRead[n2];
            d2 += this.operandsRead[n2 + 1];
        }
        n2 = Math.abs(d) > Math.abs(d2) ? 1 : 0;
        for (n = 0; n < 6; n += 2) {
            this.x += this.operandsRead[n];
            this.y += this.operandsRead[n + 1];
            this.pt[n] = (float)this.x;
            this.pt[n + 1] = (float)this.y;
        }
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (bl) {
            System.out.println("flex1 first curve " + this.operandsRead[0] + " " + this.operandsRead[1] + " " + this.operandsRead[2] + " " + this.operandsRead[3] + " " + this.operandsRead[4] + " " + this.operandsRead[5]);
        }
        for (n = 0; n < 4; n += 2) {
            this.x += this.operandsRead[n + 6];
            this.y += this.operandsRead[n + 7];
            this.pt[n] = (float)this.x;
            this.pt[n + 1] = (float)this.y;
        }
        if (n2 != 0) {
            this.x += this.operandsRead[10];
            this.y = d4;
        } else {
            this.x = d3;
            this.y += this.operandsRead[10];
        }
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (bl) {
            System.out.println("flex1 second curve " + this.operandsRead[0] + " " + this.operandsRead[1] + " " + this.operandsRead[2] + " " + this.operandsRead[3] + " " + this.operandsRead[4] + " " + this.operandsRead[5]);
        }
    }

    private void flex(GlyphFactory glyphFactory, boolean bl) {
        for (int i = 0; i < 12; i += 6) {
            for (int j = 0; j < 6; j += 2) {
                this.x += this.operandsRead[i + j];
                this.y += this.operandsRead[i + j + 1];
                this.pt[j] = (float)this.x;
                this.pt[j + 1] = (float)this.y;
            }
            glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
            if (!bl) continue;
            System.out.println("flex " + this.pt[0] + " " + this.pt[1] + " " + this.pt[2] + " " + this.pt[3] + " " + this.pt[4] + " " + this.pt[5]);
        }
    }

    private void hflex(GlyphFactory glyphFactory, boolean bl) {
        this.x += this.operandsRead[0];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[1];
        this.y += this.operandsRead[2];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[3];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (bl) {
            System.out.println("hflex first curve " + this.operandsRead[0] + " " + this.operandsRead[1] + " " + this.operandsRead[2] + " " + this.operandsRead[3] + " " + this.operandsRead[4] + " " + this.operandsRead[5]);
        }
        this.x += this.operandsRead[4];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[5];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[6];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (bl) {
            System.out.println("hflex second curve " + this.operandsRead[0] + " " + this.operandsRead[1] + " " + this.operandsRead[2] + " " + this.operandsRead[3] + " " + this.operandsRead[4] + " " + this.operandsRead[5]);
        }
    }

    private void hflex1(GlyphFactory glyphFactory, boolean bl) {
        this.x += this.operandsRead[0];
        this.y += this.operandsRead[1];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[2];
        this.y += this.operandsRead[3];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[4];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (bl) {
            System.out.println("36 first curve " + this.operandsRead[0] + " " + this.operandsRead[1] + " " + this.operandsRead[2] + " " + this.operandsRead[3] + " " + this.operandsRead[4] + " " + this.operandsRead[5]);
        }
        this.x += this.operandsRead[5];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[6];
        this.y += this.operandsRead[7];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[8];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        if (bl) {
            System.out.println("36 second curve " + this.operandsRead[0] + " " + this.operandsRead[1] + " " + this.operandsRead[2] + " " + this.operandsRead[3] + " " + this.operandsRead[4] + " " + this.operandsRead[5]);
        }
    }

    public PdfGlyph getEmbeddedGlyph(GlyphFactory glyphFactory, String string, float[][] fArray, int n, String string2, float f, String string3) {
        PdfGlyph pdfGlyph;
        if (this.lastTrm[0][0] != fArray[0][0] | this.lastTrm[1][0] != fArray[1][0] | this.lastTrm[0][1] != fArray[0][1] | this.lastTrm[1][1] != fArray[1][1]) {
            this.lastTrm = fArray;
            this.cachedShapes = null;
        }
        if ((pdfGlyph = this.getEmbeddedCachedShape(n)) == null) {
            this.operandsRead = new double[this.max];
            this.operandReached = 0;
            this.x = -glyphFactory.getLSB();
            this.y = 0.0;
            this.getGlyph(string3, glyphFactory, string, n, string2, f, false);
            pdfGlyph = glyphFactory.getGlyph(false);
            this.setEmbeddedCachedShape(n, pdfGlyph);
        }
        return pdfGlyph;
    }

    public final int getNumber(byte[] byArray, int n, double[] dArray, int n2, boolean bl) {
        double d = 0.0;
        int n3 = byArray[n] & 0xFF;
        if (n3 < 28 | n3 == 31) {
            System.err.println("!!!!Incorrect type1C operand");
        } else if (n3 == 28) {
            d = (byArray[n + 1] << 8) + (byArray[n + 2] & 0xFF);
            n += 3;
        } else if (n3 == 255) {
            if (this.is1C) {
                int n4 = ((byArray[n + 1] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
                if (n4 > 32768) {
                    n4 = 65536 - n4;
                }
                double d2 = n4;
                double d3 = ((byArray[n + 3] & 0xFF) << 8) + (byArray[n + 4] & 0xFF);
                d = d2 + d3 / 65536.0;
                if (byArray[n + 1] < 0) {
                    if (bl) {
                        System.out.println("Negative " + d);
                    }
                    d = -d;
                }
                if (bl) {
                    System.out.println("x=" + d);
                    for (int i = 0; i < 5; ++i) {
                        System.out.println(i + " " + byArray[n + i] + " " + (byArray[n + i] & 0xFF) + " " + (byArray[n + i] & 0x7F));
                    }
                }
            } else {
                d = ((byArray[n + 1] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 8) + (byArray[n + 4] & 0xFF);
            }
            n += 5;
        } else if (n3 == 29) {
            d = ((byArray[n + 1] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 8) + (byArray[n + 4] & 0xFF);
            n += 5;
        } else if (n3 == 30) {
            char[] cArray = new char[65];
            ++n;
            int n5 = 0;
            while (n5 < 64) {
                int n6 = byArray[n++] & 0xFF;
                int n7 = n6 >> 4 & 0xF;
                int n8 = n6 & 0xF;
                if (n7 == 15) break;
                cArray[n5++] = nybChars.charAt(n7);
                if (n5 == 64) break;
                if (n7 == 12) {
                    cArray[n5++] = 45;
                }
                if (n5 == 64 || n8 == 15) break;
                cArray[n5++] = nybChars.charAt(n8);
                if (n5 == 64) break;
                if (n8 != 12) continue;
                cArray[n5++] = 45;
            }
            d = Double.valueOf(new String(cArray, 0, n5));
        } else if (n3 < 247) {
            d = n3 - 139;
            ++n;
        } else if (n3 < 251) {
            d = (n3 - 247 << 8) + (byArray[n + 1] & 0xFF) + 108;
            n += 2;
        } else {
            d = -(n3 - 251 << 8) - (byArray[n + 1] & 0xFF) - 108;
            n += 2;
        }
        dArray[n2] = d;
        return n;
    }

    protected void getGlyph(String string, GlyphFactory glyphFactory, String string2, int n, String string3, float f, boolean bl) {
        block90: {
            int n2;
            byte[] byArray = null;
            boolean bl2 = false;
            this.allowAll = false;
            if (this.isCID) {
                byArray = (byte[])this.charStrings.get("" + n);
            } else {
                if (string2 == null) {
                    string2 = string3;
                }
                if (string2 == null && (string2 = string) == null) {
                    string2 = ".notdef";
                }
                if ((byArray = (byte[])this.charStrings.get(string2)) == null) {
                    if (string != null) {
                        byArray = (byte[])this.charStrings.get(string);
                    }
                    if (byArray == null) {
                        byArray = (byte[])this.charStrings.get(".notdef");
                    }
                }
            }
            if (byArray == null) break block90;
            boolean bl3 = true;
            boolean bl4 = false;
            this.ptCount = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = byArray.length;
            int n7 = 0;
            this.currentOp = 0;
            this.hintCount = 0;
            double d = 999999.0;
            double d2 = 0.0;
            double d3 = 1000.0;
            boolean bl5 = false;
            this.pt = new float[6];
            this.h = 100000.0;
            if (this.is1C) {
                this.operandsRead = new double[this.max];
                this.operandReached = 0;
                this.allowAll = true;
            }
            if (bl2) {
                System.out.println("****************** " + string3 + " " + string2);
                for (n2 = 0; n2 < n6; ++n2) {
                    System.out.println(n2 + " " + (byArray[n2] & 0xFF));
                }
                System.out.println("=====");
            }
            while (n3 < n6) {
                block92: {
                    block94: {
                        int n8;
                        block101: {
                            block103: {
                                block102: {
                                    block100: {
                                        block99: {
                                            block98: {
                                                block97: {
                                                    block96: {
                                                        block95: {
                                                            block93: {
                                                                block91: {
                                                                    int n9 = byArray[n3] & 0xFF;
                                                                    if (n9 > 31 || n9 == 28) {
                                                                        n4 = n3;
                                                                        bl4 = true;
                                                                        n3 = this.getNumber(byArray, n3, this.operandsRead, this.operandReached, bl2);
                                                                        n7 = (int)this.operandsRead[this.operandReached];
                                                                        ++this.operandReached;
                                                                        if (n9 != 28 || !bl2) continue;
                                                                        System.out.println("Shortint " + n7);
                                                                        continue;
                                                                    }
                                                                    bl4 = false;
                                                                    n8 = n5;
                                                                    n5 = n9;
                                                                    ++n3;
                                                                    this.currentOp = 0;
                                                                    if (n5 != 12) break block91;
                                                                    n5 = byArray[n3] & 0xFF;
                                                                    ++n3;
                                                                    if (n5 == 7) {
                                                                        d3 = this.sbw(bl2);
                                                                        this.operandReached = 0;
                                                                    } else if (this.allowAll) {
                                                                        if (n5 == 16) {
                                                                            bl5 = this.processFlex(glyphFactory, bl2, n8, bl5, n7);
                                                                            this.operandReached = 0;
                                                                        } else if (n5 == 33) {
                                                                            this.setcurrentpoint(bl2);
                                                                            this.operandReached = 0;
                                                                        } else if (n5 == 34) {
                                                                            this.hflex(glyphFactory, bl2);
                                                                            this.operandReached = 0;
                                                                        } else if (n5 == 35) {
                                                                            this.flex(glyphFactory, bl2);
                                                                            this.operandReached = 0;
                                                                        } else if (n5 == 36) {
                                                                            this.hflex1(glyphFactory, bl2);
                                                                            this.operandReached = 0;
                                                                        } else if (n5 == 37) {
                                                                            this.flex1(glyphFactory, bl2);
                                                                            this.operandReached = 0;
                                                                        } else if (n5 == 6) {
                                                                            this.seac(glyphFactory, n, this.currentOp);
                                                                            this.operandReached = 0;
                                                                        } else if (n5 == 12) {
                                                                            this.div(bl2);
                                                                        } else if (n5 == 17) {
                                                                            this.pop(bl2);
                                                                        } else if (n5 == 0) {
                                                                            this.operandReached = 0;
                                                                            if (bl2) {
                                                                                System.out.println("Dot section");
                                                                            }
                                                                        } else if (bl2) {
                                                                            this.operandReached = 0;
                                                                            System.out.println("1 Not implemented " + n3 + " id=" + n5 + " op=" + Type1.T1C[n5]);
                                                                        } else {
                                                                            this.operandReached = 0;
                                                                        }
                                                                    }
                                                                    break block92;
                                                                }
                                                                if (n5 != 13) break block93;
                                                                this.hsbw(glyphFactory, bl2);
                                                                this.operandReached = 0;
                                                                break block92;
                                                            }
                                                            if (!this.allowAll) break block92;
                                                            if (n5 == 0) break block94;
                                                            if (!(n5 == 1 | n5 == 3 | n5 == 18 | n5 == 23)) break block95;
                                                            this.hintCount += this.operandReached / 2;
                                                            this.operandReached = 0;
                                                            if (bl2) {
                                                                System.out.println("One of hstem vstem hstemhm vstemhm " + n5 + " " + this.xs + " " + this.ys);
                                                            }
                                                            break block94;
                                                        }
                                                        if (n5 != 4) break block96;
                                                        if (bl5) {
                                                            double d4 = this.operandsRead[this.currentOp];
                                                            this.y += d4;
                                                            this.pt[this.ptCount] = (float)this.x;
                                                            ++this.ptCount;
                                                            this.pt[this.ptCount] = (float)this.y;
                                                            ++this.ptCount;
                                                            if (bl2) {
                                                                System.out.println("flex value " + this.x + " " + this.y);
                                                            }
                                                        } else {
                                                            this.vmoveto(glyphFactory, bl2, bl3);
                                                        }
                                                        this.operandReached = 0;
                                                        break block94;
                                                    }
                                                    if (n5 != 5) break block97;
                                                    this.rlineto(glyphFactory, bl2);
                                                    this.operandReached = 0;
                                                    break block94;
                                                }
                                                if (!(n5 == 6 | n5 == 7)) break block98;
                                                this.hvlineto(glyphFactory, bl2, n5);
                                                this.operandReached = 0;
                                                break block94;
                                            }
                                            if (n5 != 8) break block99;
                                            this.rrcurveto(glyphFactory, bl2);
                                            this.operandReached = 0;
                                            break block94;
                                        }
                                        if (n5 != 9) break block100;
                                        this.closepath(glyphFactory, bl2);
                                        this.operandReached = 0;
                                        break block94;
                                    }
                                    if (n5 != 10 && n5 != 29) break block101;
                                    if (bl2) {
                                        System.out.println(n5 + " -------------- " + n7);
                                    }
                                    if (n5 != 10 || n7 < 0 || n7 > 2 || n8 == 11) break block102;
                                    bl5 = this.processFlex(glyphFactory, bl2, n8, bl5, n7);
                                    this.operandReached = 0;
                                    break block94;
                                }
                                n7 = n5 == 10 ? (n7 += this.localBias) : (n7 += this.globalBias);
                                byte[] byArray2 = null;
                                if (n5 == 10) {
                                    byArray2 = (byte[])this.charStrings.get("subrs" + n7);
                                    if (bl2) {
                                        System.out.println("=================callsubr " + n7);
                                    }
                                } else {
                                    if (bl2) {
                                        System.out.println("=================callgsubr " + n7);
                                    }
                                    byArray2 = (byte[])this.charStrings.get("global" + n7);
                                }
                                if (byArray2 == null) break block103;
                                if (bl2) {
                                    System.out.println("Subroutine=============" + n7 + " op=" + this.currentOp + " " + this.operandReached);
                                }
                                int n10 = byArray2.length;
                                int n11 = byArray.length;
                                int n12 = n10 + n11 - 2;
                                n6 = n6 + n10 - 2;
                                byte[] byArray3 = new byte[n12];
                                System.arraycopy(byArray, 0, byArray3, 0, n4);
                                System.arraycopy(byArray2, 0, byArray3, n4, n10);
                                System.arraycopy(byArray, n3, byArray3, n4 + n10, n11 - n3);
                                byArray = byArray3;
                                n3 = n4;
                                if (this.operandReached > 0) {
                                    --this.operandReached;
                                }
                                break block94;
                            }
                            if (!bl2) break block94;
                            System.out.println("No data found for sub-routine " + this.charStrings);
                            break block94;
                        }
                        if (n5 == 11) {
                            if (bl2) {
                                System.out.println("return=============" + n3);
                            }
                        } else if (n5 == 14) {
                            n3 = this.endchar(glyphFactory, n, bl2, n6);
                            this.operandReached = 0;
                            n3 = n6 + 1;
                        } else if (n5 == 16) {
                            if (bl2) {
                                System.out.println("Blend");
                            }
                            this.operandReached = 0;
                        } else if (n5 == 19 | n5 == 20) {
                            n3 = this.mask(bl2, n3, n8);
                            this.operandReached = 0;
                        } else if (n5 == 21) {
                            if (bl5) {
                                if (bl2) {
                                    System.out.println(this.currentOp + " " + this.ptCount + " " + this.pt.length);
                                }
                                double d5 = this.operandsRead[this.currentOp + 1];
                                this.y += d5;
                                d5 = this.operandsRead[this.currentOp];
                                this.x += d5;
                                this.pt[this.ptCount] = (float)this.x;
                                ++this.ptCount;
                                this.pt[this.ptCount] = (float)this.y;
                                ++this.ptCount;
                                if (bl2) {
                                    System.out.println("flex value " + this.pt[this.ptCount - 2] + " " + this.pt[this.ptCount - 1] + " count=" + this.ptCount);
                                }
                            } else {
                                this.rmoveto(glyphFactory, bl2, bl3);
                            }
                            this.operandReached = 0;
                        } else if (n5 == 22) {
                            if (bl5) {
                                double d6 = this.operandsRead[this.currentOp];
                                this.x += d6;
                                this.pt[this.ptCount] = (float)this.x;
                                ++this.ptCount;
                                this.pt[this.ptCount] = (float)this.y;
                                ++this.ptCount;
                                if (bl2) {
                                    System.out.println("flex value " + this.x + " " + this.y);
                                }
                            } else {
                                this.hmoveto(glyphFactory, bl2, bl3);
                            }
                            this.operandReached = 0;
                        } else if (n5 == 24) {
                            this.rcurveline(glyphFactory, bl2);
                            this.operandReached = 0;
                        } else if (n5 == 25) {
                            this.rlinecurve(glyphFactory, bl2);
                            this.operandReached = 0;
                        } else if (n5 == 26 | n5 == 27) {
                            this.vvhhcurveto(glyphFactory, bl2, n5);
                            this.operandReached = 0;
                        } else if (n5 == 30 | n5 == 31) {
                            this.vhhvcurveto(glyphFactory, bl2, n5);
                            this.operandReached = 0;
                        } else if (bl2) {
                            this.operandReached = 0;
                            System.out.println("Unsupported command " + n3 + ">>>>>" + this.hintCount + ">>>>>>key=" + n5 + " " + Type1.T1CcharCodes1Byte[n5] + " <1<<" + this.operandsRead);
                            for (n2 = 0; n2 < n6; ++n2) {
                                System.out.println(n2 + " " + (byArray[n2] & 0xFF));
                            }
                        }
                    }
                    if (bl2 && !bl4) {
                        BufferedImage bufferedImage = new BufferedImage(600, 600, 2);
                        Graphics2D graphics2D = bufferedImage.createGraphics();
                        graphics2D.setColor(Color.red);
                        AffineTransform affineTransform = new AffineTransform();
                        affineTransform.scale(0.5, 0.5);
                        affineTransform.translate(0.0, 340.0);
                        graphics2D.transform(affineTransform);
                        PdfGlyph pdfGlyph = glyphFactory.getGlyph(true);
                        pdfGlyph.render(1, graphics2D, bl2, 1.0f);
                        ShowGUIMessage.showGUIMessage(n3 + " x " + " x,y=" + this.x + " " + this.y, bufferedImage, n3 + " x ");
                    }
                }
                if (d > this.y) {
                    d = this.y;
                }
                if (d2 < this.y) {
                    d2 = this.y;
                }
                if (n5 == 19) continue;
                bl3 = false;
            }
            if (d3 > this.h) {
                d = d3 - this.h;
            }
            if (d2 < d3) {
                d = 0.0;
            } else if (d3 != d2) {
                float f2 = (float)(d2 - (d3 - d));
                d = f2 < 0.0f ? (d3 - d2 <= (double)f2 ? (double)f2 : (d -= (double)f2)) : 0.0;
                if (d < 0.0) {
                    d = 0.0;
                }
            }
            glyphFactory.setYMin((float)d, (float)d2);
            if (bl2 & !bl) {
                BufferedImage bufferedImage = new BufferedImage(600, 600, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setColor(Color.red);
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.scale(0.25, 0.25);
                graphics2D.transform(affineTransform);
                PdfGlyph pdfGlyph = glyphFactory.getGlyph(true);
                graphics2D.setColor(Color.green);
                for (int i = 0; i < 7; ++i) {
                    graphics2D.drawLine(0, i * 50, 1000, i * 50);
                }
                pdfGlyph.render(1, graphics2D, bl2, 1.0f);
            }
        }
    }

    public void setCharString(String string, byte[] byArray) {
        this.charStrings.put(string, byArray);
    }

    public boolean is1C() {
        return this.is1C;
    }

    public void setis1C(boolean bl) {
        this.is1C = bl;
    }
}

