/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.model;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.HoverProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectScene
extends Scene {
    private static final ObjectSceneListener[] EMPTY_LISTENERS = new ObjectSceneListener[0];
    private static final Set<Object> EMPTY_SET = Collections.unmodifiableSet(Collections.emptySet());
    private static final Widget[] EMPTY_WIDGETS_ARRAY = new Widget[0];
    private static final List<Widget> EMPTY_WIDGETS_LIST = Collections.emptyList();
    private HashMap<Object, Object> objects = new HashMap();
    private Set<Object> objectsUm = Collections.unmodifiableSet(this.objects.keySet());
    private HashMap<Object, Widget> object2widget = new HashMap();
    private HashMap<Object, List<Widget>> object2widgets = new HashMap();
    private HashMap<Widget, Object> widget2object = new HashMap();
    private HashMap<Object, ObjectState> objectStates = new HashMap();
    private HashSet<Object> selectedObjects = new HashSet();
    private Set<Object> selectedObjectsUm = Collections.unmodifiableSet(this.selectedObjects);
    private HashSet<Object> highlightedObjects = new HashSet();
    private Set<Object> highlightedObjectsUm = Collections.unmodifiableSet(this.highlightedObjects);
    private Object focusedObject = null;
    private Object hoveredObject = null;
    private WidgetAction selectAction = ActionFactory.createSelectAction(new ObjectSelectProvider(), true);
    private WidgetAction objectHoverAction;
    private Map<ObjectSceneEventType, List<ObjectSceneListener>> listeners = new EnumMap<ObjectSceneEventType, List<ObjectSceneListener>>(ObjectSceneEventType.class);
    private ObjectSceneEvent event = new ObjectSceneEvent(this);

    public final void addObject(Object object, Widget ... widgets) {
        Widget mainWidget;
        assert (object != null && !(object instanceof Widget) && !this.objects.containsKey(object));
        Widget widget = mainWidget = widgets.length > 0 ? widgets[0] : null;
        if (mainWidget == null) {
            widgets = EMPTY_WIDGETS_ARRAY;
        }
        for (Widget widget2 : widgets) {
            assert (widget2 != null);
            assert (!this.widget2object.containsKey(widget2) && widget2.getScene() == this);
        }
        this.objects.put(object, object);
        this.object2widget.put(object, mainWidget);
        this.object2widgets.put(object, mainWidget != null ? Arrays.asList(widgets) : EMPTY_WIDGETS_LIST);
        this.objectStates.put(object, ObjectState.createNormal());
        for (Widget widget2 : widgets) {
            this.widget2object.put(widget2, object);
            widget2.setState(ObjectState.createNormal());
        }
        for (ObjectSceneListener listener : this.getListeners(ObjectSceneEventType.OBJECT_ADDED)) {
            listener.objectAdded(this.event, object);
        }
    }

    public final void removeObject(Object object) {
        HashSet<Object> temp;
        assert (object != null && this.objects.containsKey(object));
        if (this.selectedObjects.contains(object)) {
            temp = new HashSet<Object>(this.selectedObjects);
            temp.remove(object);
            this.setSelectedObjects(temp);
        }
        if (this.highlightedObjects.contains(object)) {
            temp = new HashSet<Object>(this.highlightedObjects);
            temp.remove(object);
            this.setHighlightedObjects(temp);
        }
        if (object.equals(this.hoveredObject)) {
            this.setHoveredObject(null);
        }
        if (object.equals(this.focusedObject)) {
            this.setFocusedObject(null);
        }
        this.objectStates.remove(object);
        this.object2widget.remove(object);
        List<Widget> widgets = this.object2widgets.remove(object);
        for (Widget widget : widgets) {
            this.widget2object.remove(widget);
        }
        this.objects.remove(object);
        for (ObjectSceneListener listener : this.getListeners(ObjectSceneEventType.OBJECT_REMOVED)) {
            listener.objectRemoved(this.event, object);
        }
    }

    public final Set<?> getObjects() {
        return this.objectsUm;
    }

    public final boolean isObject(Object object) {
        return this.objects.containsKey(object);
    }

    public final Set<?> getSelectedObjects() {
        return this.selectedObjectsUm;
    }

    public final void setSelectedObjects(Set<?> selectedObjects) {
        ObjectState newState;
        ObjectState previousState;
        ObjectSceneListener[] listeners = this.getListeners(ObjectSceneEventType.OBJECT_STATE_CHANGED);
        ObjectSceneListener[] selectionListeners = this.getListeners(ObjectSceneEventType.OBJECT_SELECTION_CHANGED);
        Set<Object> previouslySelectedObject = selectionListeners.length != 0 ? Collections.unmodifiableSet(new HashSet<Object>(this.selectedObjects)) : EMPTY_SET;
        Iterator<Object> iterator = this.selectedObjects.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (selectedObjects.contains(object)) continue;
            iterator.remove();
            previousState = this.objectStates.get(object);
            newState = previousState.deriveSelected(false);
            this.objectStates.put(object, newState);
            for (Widget widget : this.object2widgets.get(object)) {
                widget.setState(widget.getState().deriveSelected(false));
            }
            for (ObjectSceneListener listener : listeners) {
                listener.objectStateChanged(this.event, object, previousState, newState);
            }
        }
        for (Object object : selectedObjects) {
            if (this.selectedObjects.contains(object)) continue;
            this.selectedObjects.add(object);
            previousState = this.objectStates.get(object);
            newState = previousState.deriveSelected(true);
            this.objectStates.put(object, newState);
            for (Widget widget : this.object2widgets.get(object)) {
                widget.setState(widget.getState().deriveSelected(true));
            }
            for (ObjectSceneListener listener : listeners) {
                listener.objectStateChanged(this.event, object, previousState, newState);
            }
        }
        for (ObjectSceneListener listener : selectionListeners) {
            listener.selectionChanged(this.event, previouslySelectedObject, this.selectedObjectsUm);
        }
    }

    public final Set<?> getHighlightedObjects() {
        return this.highlightedObjectsUm;
    }

    public final void setHighlightedObjects(Set<?> highlightedObjects) {
        ObjectState newState;
        ObjectState previousState;
        ObjectSceneListener[] listeners = this.getListeners(ObjectSceneEventType.OBJECT_STATE_CHANGED);
        ObjectSceneListener[] highlightingListeners = this.getListeners(ObjectSceneEventType.OBJECT_HIGHLIGHTING_CHANGED);
        Set<Object> previouslyHighlightedObject = highlightingListeners.length != 0 ? Collections.unmodifiableSet(new HashSet<Object>(this.highlightedObjects)) : EMPTY_SET;
        Iterator<Object> iterator = this.highlightedObjects.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (highlightedObjects.contains(object)) continue;
            iterator.remove();
            previousState = this.objectStates.get(object);
            newState = previousState.deriveHighlighted(false);
            this.objectStates.put(object, newState);
            for (Widget widget : this.object2widgets.get(object)) {
                widget.setState(widget.getState().deriveHighlighted(false));
            }
            for (ObjectSceneListener listener : listeners) {
                listener.objectStateChanged(this.event, object, previousState, newState);
            }
        }
        for (Object object : highlightedObjects) {
            if (this.highlightedObjects.contains(object)) continue;
            this.highlightedObjects.add(object);
            previousState = this.objectStates.get(object);
            newState = previousState.deriveHighlighted(true);
            this.objectStates.put(object, newState);
            for (Widget widget : this.object2widgets.get(object)) {
                widget.setState(widget.getState().deriveHighlighted(true));
            }
            for (ObjectSceneListener listener : listeners) {
                listener.objectStateChanged(this.event, object, previousState, newState);
            }
        }
        for (ObjectSceneListener listener : highlightingListeners) {
            listener.highlightingChanged(this.event, previouslyHighlightedObject, this.highlightedObjectsUm);
        }
    }

    public final Object getHoveredObject() {
        return this.hoveredObject;
    }

    public final void setHoveredObject(Object hoveredObject) {
        ObjectState newState;
        ObjectState previousState;
        if (hoveredObject != null ? hoveredObject.equals(this.hoveredObject) : this.hoveredObject == null) {
            return;
        }
        ObjectSceneListener[] listeners = this.getListeners(ObjectSceneEventType.OBJECT_STATE_CHANGED);
        ObjectSceneListener[] hoverListeners = this.getListeners(ObjectSceneEventType.OBJECT_HOVER_CHANGED);
        Object previouslyHoveredObject = this.hoveredObject;
        if (this.hoveredObject != null) {
            previousState = this.objectStates.get(this.hoveredObject);
            newState = previousState.deriveObjectHovered(false);
            this.objectStates.put(this.hoveredObject, newState);
            for (Widget widget : this.object2widgets.get(this.hoveredObject)) {
                widget.setState(widget.getState().deriveObjectHovered(false));
            }
            for (ObjectSceneListener listener : listeners) {
                listener.objectStateChanged(this.event, this.hoveredObject, previousState, newState);
            }
        }
        this.hoveredObject = hoveredObject;
        if (this.hoveredObject != null) {
            previousState = this.objectStates.get(this.hoveredObject);
            newState = previousState.deriveObjectHovered(true);
            this.objectStates.put(this.hoveredObject, newState);
            for (Widget widget : this.object2widgets.get(this.hoveredObject)) {
                widget.setState(widget.getState().deriveObjectHovered(true));
            }
            for (ObjectSceneListener listener : listeners) {
                listener.objectStateChanged(this.event, this.hoveredObject, previousState, newState);
            }
        }
        for (ObjectSceneListener listener : hoverListeners) {
            listener.hoverChanged(this.event, previouslyHoveredObject, this.hoveredObject);
        }
    }

    public final Object getFocusedObject() {
        return this.focusedObject;
    }

    public final void setFocusedObject(Object focusedObject) {
        ObjectState newState;
        ObjectState previousState;
        if (focusedObject != null ? focusedObject.equals(this.focusedObject) : this.focusedObject == null) {
            return;
        }
        ObjectSceneListener[] listeners = this.getListeners(ObjectSceneEventType.OBJECT_STATE_CHANGED);
        ObjectSceneListener[] focusListeners = this.getListeners(ObjectSceneEventType.OBJECT_FOCUS_CHANGED);
        Object previouslyFocusedObject = this.focusedObject;
        if (this.focusedObject != null) {
            previousState = this.objectStates.get(this.focusedObject);
            newState = previousState.deriveObjectFocused(false);
            this.objectStates.put(this.focusedObject, newState);
            for (Widget widget : this.object2widgets.get(this.focusedObject)) {
                widget.setState(widget.getState().deriveObjectFocused(false));
            }
            for (ObjectSceneListener listener : listeners) {
                listener.objectStateChanged(this.event, this.focusedObject, previousState, newState);
            }
        }
        this.focusedObject = focusedObject;
        if (this.focusedObject != null) {
            previousState = this.objectStates.get(this.focusedObject);
            newState = previousState.deriveObjectFocused(true);
            this.objectStates.put(this.focusedObject, newState);
            for (Widget widget : this.object2widgets.get(this.focusedObject)) {
                widget.setState(widget.getState().deriveObjectFocused(true));
            }
            for (ObjectSceneListener listener : listeners) {
                listener.objectStateChanged(this.event, this.focusedObject, previousState, newState);
            }
            this.setFocusedWidget(this.object2widget.get(this.focusedObject));
        } else {
            this.setFocusedWidget(null);
        }
        for (ObjectSceneListener listener : focusListeners) {
            listener.focusChanged(this.event, previouslyFocusedObject, this.focusedObject);
        }
    }

    public final WidgetAction createSelectAction() {
        return this.selectAction;
    }

    public final WidgetAction createObjectHoverAction() {
        if (this.objectHoverAction == null) {
            this.objectHoverAction = ActionFactory.createHoverAction(new ObjectHoverProvider());
            this.getActions().addAction(this.objectHoverAction);
        }
        return this.objectHoverAction;
    }

    public final Widget findWidget(Object object) {
        assert (!(object instanceof Widget)) : "Use findObject method for getting an object assigned to a specific Widget";
        return this.object2widget.get(object);
    }

    public final List<Widget> findWidgets(Object object) {
        assert (!(object instanceof Widget)) : "Use findObject method for getting an object assigned to a specific Widget";
        return this.object2widgets.get(object);
    }

    public final Object findObject(Widget widget) {
        while (widget != null) {
            Object o = this.widget2object.get(widget);
            if (o != null) {
                return o;
            }
            widget = widget.getParentWidget();
        }
        return null;
    }

    public final Object findStoredObject(Object object) {
        assert (!(object instanceof Widget)) : "Use findObject method for getting an object assigned to a specific Widget";
        return this.objects.get(object);
    }

    public final ObjectState getObjectState(Object object) {
        return this.objectStates.get(object);
    }

    public void userSelectionSuggested(Set<?> suggestedSelectedObjects, boolean invertSelection) {
        if (invertSelection) {
            HashSet objects = new HashSet(this.getSelectedObjects());
            for (Object o : suggestedSelectedObjects) {
                if (objects.contains(o)) {
                    objects.remove(o);
                    continue;
                }
                objects.add(o);
            }
            this.setSelectedObjects(objects);
        } else {
            this.setSelectedObjects(suggestedSelectedObjects);
        }
    }

    public Comparable getIdentityCode(Object object) {
        return object != null ? Integer.valueOf(System.identityHashCode(object)) : null;
    }

    public final void addObjectSceneListener(ObjectSceneListener listener, ObjectSceneEventType ... types) {
        for (ObjectSceneEventType type : types) {
            this.addObjectSceneListenerCore(listener, type);
        }
    }

    private void addObjectSceneListenerCore(ObjectSceneListener listener, ObjectSceneEventType type) {
        List<ObjectSceneListener> list = this.listeners.get((Object)type);
        if (list == null) {
            list = new ArrayList<ObjectSceneListener>();
            this.listeners.put(type, list);
        }
        list.add(listener);
    }

    public final void removeObjectSceneListener(ObjectSceneListener listener, ObjectSceneEventType ... types) {
        for (ObjectSceneEventType type : types) {
            this.removeObjectSceneListenerCore(listener, type);
        }
    }

    private void removeObjectSceneListenerCore(ObjectSceneListener listener, ObjectSceneEventType type) {
        List<ObjectSceneListener> list = this.listeners.get((Object)type);
        if (list == null) {
            return;
        }
        list.remove(listener);
        if (list.isEmpty()) {
            this.listeners.remove((Object)type);
        }
    }

    private ObjectSceneListener[] getListeners(ObjectSceneEventType type) {
        List<ObjectSceneListener> listeners = this.listeners.get((Object)type);
        if (listeners == null) {
            return EMPTY_LISTENERS;
        }
        return listeners.toArray(new ObjectSceneListener[listeners.size()]);
    }

    private class ObjectHoverProvider
    implements HoverProvider {
        private ObjectHoverProvider() {
        }

        public void widgetHovered(Widget widget) {
            if (ObjectScene.this == widget) {
                widget = null;
            }
            ObjectScene.this.setHoveredObject(ObjectScene.this.findObject(widget));
        }
    }

    private class ObjectSelectProvider
    implements SelectProvider {
        private ObjectSelectProvider() {
        }

        public boolean isAimingAllowed(Widget widget, Point localLocation, boolean invertSelection) {
            return false;
        }

        public boolean isSelectionAllowed(Widget widget, Point localLocation, boolean invertSelection) {
            return ObjectScene.this.findObject(widget) != null;
        }

        public void select(Widget widget, Point localLocation, boolean invertSelection) {
            Object object = ObjectScene.this.findObject(widget);
            ObjectScene.this.setFocusedObject(object);
            if (object != null) {
                if (!invertSelection && ObjectScene.this.getSelectedObjects().contains(object)) {
                    return;
                }
                ObjectScene.this.userSelectionSuggested(Collections.singleton(object), invertSelection);
            } else {
                ObjectScene.this.userSelectionSuggested(Collections.emptySet(), invertSelection);
            }
        }
    }
}

