/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.vmd;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.vmd.VMDColorScheme;
import org.netbeans.api.visual.vmd.VMDFactory;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMDNodeAnchor
extends Anchor {
    private boolean requiresRecalculation = true;
    private HashMap<Anchor.Entry, Anchor.Result> results = new HashMap();
    private final boolean vertical;
    private VMDColorScheme scheme;

    public VMDNodeAnchor(Widget widget) {
        this(widget, true);
    }

    public VMDNodeAnchor(Widget widget, boolean vertical) {
        this(widget, vertical, VMDFactory.getOriginalScheme());
    }

    public VMDNodeAnchor(Widget widget, boolean vertical, VMDColorScheme scheme) {
        super(widget);
        assert (widget != null);
        assert (scheme != null);
        this.vertical = vertical;
        this.scheme = scheme;
    }

    @Override
    protected void notifyEntryAdded(Anchor.Entry entry) {
        this.requiresRecalculation = true;
    }

    @Override
    protected void notifyEntryRemoved(Anchor.Entry entry) {
        this.results.remove(entry);
        this.requiresRecalculation = true;
    }

    @Override
    protected void notifyRevalidate() {
        this.requiresRecalculation = true;
    }

    private void recalculate() {
        Anchor.Entry entry;
        int a;
        if (!this.requiresRecalculation) {
            return;
        }
        Widget widget = this.getRelatedWidget();
        Point relatedLocation = this.getRelatedSceneLocation();
        Rectangle bounds = widget.convertLocalToScene(widget.getBounds());
        HashMap<Anchor.Entry, Float> topmap = new HashMap<Anchor.Entry, Float>();
        HashMap<Anchor.Entry, Float> bottommap = new HashMap<Anchor.Entry, Float>();
        for (Anchor.Entry entry2 : this.getEntries()) {
            Point oppositeLocation = this.getOppositeSceneLocation(entry2);
            if (oppositeLocation == null || relatedLocation == null) {
                this.results.put(entry2, (Anchor)this.new Anchor.Result(new Point(bounds.x, bounds.y), DIRECTION_ANY));
                continue;
            }
            int dy = oppositeLocation.y - relatedLocation.y;
            int dx = oppositeLocation.x - relatedLocation.x;
            if (this.vertical) {
                if (dy > 0) {
                    bottommap.put(entry2, Float.valueOf((float)dx / (float)dy));
                    continue;
                }
                if (dy < 0) {
                    topmap.put(entry2, Float.valueOf((float)(-dx) / (float)dy));
                    continue;
                }
                topmap.put(entry2, Float.valueOf(dx < 0 ? Float.MAX_VALUE : Float.MIN_VALUE));
                continue;
            }
            if (dx > 0) {
                bottommap.put(entry2, Float.valueOf((float)dy / (float)dx));
                continue;
            }
            if (dy < 0) {
                topmap.put(entry2, Float.valueOf((float)(-dy) / (float)dx));
                continue;
            }
            topmap.put(entry2, Float.valueOf(dy < 0 ? Float.MAX_VALUE : Float.MIN_VALUE));
        }
        Anchor.Entry[] topList = this.toArray(topmap);
        Anchor.Entry[] bottomList = this.toArray(bottommap);
        int pinGap = this.scheme.getNodeAnchorGap(this);
        int y = bounds.y - pinGap;
        int x = bounds.x - pinGap;
        int len = topList.length;
        for (a = 0; a < len; ++a) {
            entry = topList[a];
            if (this.vertical) {
                x = bounds.x + (a + 1) * bounds.width / (len + 1);
            } else {
                y = bounds.y + (a + 1) * bounds.height / (len + 1);
            }
            this.results.put(entry, (Anchor)this.new Anchor.Result(new Point(x, y), this.vertical ? Anchor.Direction.TOP : Anchor.Direction.LEFT));
        }
        y = bounds.y + bounds.height + pinGap;
        x = bounds.x + bounds.width + pinGap;
        len = bottomList.length;
        for (a = 0; a < len; ++a) {
            entry = bottomList[a];
            if (this.vertical) {
                x = bounds.x + (a + 1) * bounds.width / (len + 1);
            } else {
                y = bounds.y + (a + 1) * bounds.height / (len + 1);
            }
            this.results.put(entry, (Anchor)this.new Anchor.Result(new Point(x, y), this.vertical ? Anchor.Direction.BOTTOM : Anchor.Direction.RIGHT));
        }
        this.requiresRecalculation = false;
    }

    private Anchor.Entry[] toArray(final HashMap<Anchor.Entry, Float> map) {
        Set<Anchor.Entry> keys = map.keySet();
        Anchor.Entry[] entries = keys.toArray(new Anchor.Entry[keys.size()]);
        Arrays.sort(entries, new Comparator<Anchor.Entry>(){

            @Override
            public int compare(Anchor.Entry o1, Anchor.Entry o2) {
                float f = ((Float)map.get(o1)).floatValue() - ((Float)map.get(o2)).floatValue();
                if (f > 0.0f) {
                    return 1;
                }
                if (f < 0.0f) {
                    return -1;
                }
                return 0;
            }
        });
        return entries;
    }

    @Override
    public Anchor.Result compute(Anchor.Entry entry) {
        this.recalculate();
        return this.results.get(entry);
    }
}

