/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.router;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.router.CollisionsCollector;
import org.netbeans.api.visual.router.ConnectionWidgetCollisionsCollector;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.modules.visual.router.OrthogonalSearchRouterCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrthogonalSearchRouter
implements Router {
    static final int SPACING_EDGE = 8;
    static final int SPACING_NODE = 16;
    private CollisionsCollector collector;
    private ConnectionWidgetCollisionsCollector connectionWidgetCollector;

    public OrthogonalSearchRouter(CollisionsCollector collector) {
        this.collector = collector;
    }

    public OrthogonalSearchRouter(ConnectionWidgetCollisionsCollector collector) {
        this.connectionWidgetCollector = collector;
    }

    @Override
    public List<Point> routeConnection(ConnectionWidget widget) {
        int deltaX;
        Anchor.Direction targetDirection2;
        Anchor sourceAnchor = widget.getSourceAnchor();
        Anchor targetAnchor = widget.getTargetAnchor();
        if (sourceAnchor == null || targetAnchor == null) {
            return Collections.emptyList();
        }
        ArrayList<Rectangle> verticalCollisions = new ArrayList<Rectangle>();
        ArrayList<Rectangle> horizontalCollisions = new ArrayList<Rectangle>();
        if (this.collector != null) {
            this.collector.collectCollisions(verticalCollisions, horizontalCollisions);
        } else {
            this.connectionWidgetCollector.collectCollisions(widget, verticalCollisions, horizontalCollisions);
        }
        if (sourceAnchor.getRelatedWidget() == targetAnchor.getRelatedWidget()) {
            Rectangle rec = sourceAnchor.getRelatedWidget().convertLocalToScene(sourceAnchor.getRelatedWidget().getBounds());
            rec.grow(16, 16);
            verticalCollisions.add(rec);
            horizontalCollisions.add(rec);
        }
        Point originalSourceCenterPoint = sourceAnchor.getRelatedSceneLocation();
        Point originalTargetCenterPoint = targetAnchor.getRelatedSceneLocation();
        Point sourcePoint = originalSourceCenterPoint;
        Point targetPoint = originalTargetCenterPoint;
        EnumSet<Anchor.Direction> sourceDirections = Anchor.DIRECTION_ANY;
        EnumSet<Anchor.Direction> targetDirections = Anchor.DIRECTION_ANY;
        if (!sourceAnchor.allowsArbitraryConnectionPlacement()) {
            Anchor.Result sourceResult = sourceAnchor.compute(widget.getSourceAnchorEntry());
            sourceDirections = sourceResult.getDirections();
            sourcePoint = sourceResult.getAnchorSceneLocation();
        }
        if (!targetAnchor.allowsArbitraryConnectionPlacement()) {
            Anchor.Result targetResult = targetAnchor.compute(widget.getTargetAnchorEntry());
            targetDirections = targetResult.getDirections();
            targetPoint = targetResult.getAnchorSceneLocation();
        }
        Solution bestSolution = new Solution(0x1FFFFFFF, null);
        for (Anchor.Direction sourceDirection : sourceDirections) {
            for (Anchor.Direction targetDirection2 : targetDirections) {
                Solution solution = new OrthogonalSearchRouterCore(widget.getScene(), verticalCollisions, horizontalCollisions, sourcePoint, sourceDirection, targetPoint, targetDirection2).route();
                if (solution == null || solution.compareTo(bestSolution) <= 0) continue;
                bestSolution = solution;
            }
        }
        List<Point> bestListOfPoints = bestSolution.getPoints();
        if (!sourceAnchor.allowsArbitraryConnectionPlacement() && !targetAnchor.allowsArbitraryConnectionPlacement()) {
            return bestListOfPoints;
        }
        List<Point> bestPoints = bestListOfPoints;
        Anchor.Direction sourceDirection = null;
        targetDirection2 = null;
        Point firstPointOutsideAnchor = null;
        if (sourceAnchor.allowsArbitraryConnectionPlacement()) {
            bestPoints = sourceAnchor.compute(bestListOfPoints);
            firstPointOutsideAnchor = bestPoints.get(1);
            deltaX = originalSourceCenterPoint.x - firstPointOutsideAnchor.x;
            if (deltaX == 0) {
                sourceDirection = originalSourceCenterPoint.y < firstPointOutsideAnchor.y ? Anchor.Direction.BOTTOM : Anchor.Direction.TOP;
            } else {
                Anchor.Direction direction = sourceDirection = originalSourceCenterPoint.x < firstPointOutsideAnchor.x ? Anchor.Direction.RIGHT : Anchor.Direction.LEFT;
            }
        }
        if (targetAnchor.allowsArbitraryConnectionPlacement()) {
            bestPoints = targetAnchor.compute(bestPoints);
            firstPointOutsideAnchor = bestPoints.get(bestPoints.size() - 2);
            deltaX = originalTargetCenterPoint.x - firstPointOutsideAnchor.x;
            if (deltaX == 0) {
                targetDirection2 = originalTargetCenterPoint.y < firstPointOutsideAnchor.y ? Anchor.Direction.BOTTOM : Anchor.Direction.TOP;
            } else {
                Anchor.Direction direction = targetDirection2 = originalTargetCenterPoint.x < firstPointOutsideAnchor.x ? Anchor.Direction.RIGHT : Anchor.Direction.LEFT;
            }
        }
        if (sourceAnchor.allowsArbitraryConnectionPlacement() || targetAnchor.allowsArbitraryConnectionPlacement()) {
            bestSolution = new OrthogonalSearchRouterCore(widget.getScene(), verticalCollisions, horizontalCollisions, bestPoints.get(0), sourceDirection, bestPoints.get(bestPoints.size() - 1), targetDirection2).route();
        }
        return bestSolution.getPoints();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Solution
    implements Comparable<Solution> {
        private int price;
        private List<Point> points;

        public Solution(int price, List<Point> points) {
            this.price = price;
            this.points = points;
        }

        public int getPrice() {
            return this.price;
        }

        public List<Point> getPoints() {
            return this.points;
        }

        @Override
        public int compareTo(Solution other) {
            return other.price - this.price;
        }
    }
}

