/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class IconManager {
    private static final ActiveRef<String> NO_ICON = new ActiveRef<Object>(null, null, null);
    private static final Map<String, ActiveRef<String>> cache = new HashMap<String, ActiveRef<String>>(128);
    private static final Map<String, ActiveRef<String>> localizedCache = new HashMap<String, ActiveRef<String>>(128);
    private static final Map<CompositeImageKey, ActiveRef<CompositeImageKey>> compositeCache = new HashMap<CompositeImageKey, ActiveRef<CompositeImageKey>>(128);
    private static final Set<String> extraInitialSlashes = new HashSet<String>();
    private static volatile Object currentLoader;
    private static Lookup.Result<ClassLoader> loaderQuery;
    private static boolean noLoaderWarned;
    private static final Component component;
    private static final MediaTracker tracker;
    private static int mediaTrackerID;
    private static ImageReader PNG_READER;
    private static final Logger ERR;

    IconManager() {
    }

    static ClassLoader getLoader() {
        Iterator<ClassLoader> it;
        Object is = currentLoader;
        if (is instanceof ClassLoader) {
            return (ClassLoader)is;
        }
        currentLoader = Thread.currentThread();
        if (loaderQuery == null) {
            loaderQuery = Lookup.getDefault().lookup(new Lookup.Template<ClassLoader>(ClassLoader.class));
            loaderQuery.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    ERR.fine("Loader cleared");
                    currentLoader = null;
                }
            });
        }
        if ((it = loaderQuery.allInstances().iterator()).hasNext()) {
            ClassLoader toReturn = it.next();
            if (currentLoader == Thread.currentThread()) {
                currentLoader = toReturn;
            }
            ERR.fine("Loader computed: " + currentLoader);
            return toReturn;
        }
        if (!noLoaderWarned) {
            noLoaderWarned = true;
            ERR.warning("No ClassLoader instance found in " + Lookup.getDefault());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Image getIcon(String resource, boolean localized) {
        if (localized) {
            Map<String, ActiveRef<String>> map = localizedCache;
            synchronized (map) {
                String ext;
                String base;
                ActiveRef<String> ref = localizedCache.get(resource);
                Image img = null;
                if (ref == NO_ICON) {
                    return null;
                }
                if (ref != null) {
                    img = (Image)ref.get();
                }
                if (img != null) {
                    return img;
                }
                ClassLoader loader = IconManager.getLoader();
                int idx = (resource = new String(resource).intern()).lastIndexOf(46);
                if (idx != -1 && idx > resource.lastIndexOf(47)) {
                    base = resource.substring(0, idx);
                    ext = resource.substring(idx);
                } else {
                    base = resource;
                    ext = "";
                }
                URL baseurl = loader != null ? loader.getResource(resource) : IconManager.class.getClassLoader().getResource(resource);
                Iterator<String> it = NbBundle.getLocalizingSuffixes();
                while (it.hasNext()) {
                    String suffix = it.next();
                    Image i = suffix.length() == 0 ? IconManager.getIcon(resource, loader, false) : IconManager.getIcon(base + suffix + ext, loader, true);
                    if (i == null) continue;
                    localizedCache.put(resource, new ActiveRef<String>(i, localizedCache, resource));
                    return i;
                }
                localizedCache.put(resource, NO_ICON);
                return null;
            }
        }
        return IconManager.getIcon(resource, IconManager.getLoader(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image getIcon(String name, ClassLoader loader, boolean localizedQuery) {
        ActiveRef<String> ref = cache.get(name);
        Image img = null;
        if (ref == NO_ICON) {
            return null;
        }
        if (ref != null) {
            img = (Image)ref.get();
        }
        if (img != null) {
            return img;
        }
        Map<String, ActiveRef<String>> map = cache;
        synchronized (map) {
            BufferedImage result;
            String n;
            boolean warn;
            block20: {
                ref = cache.get(name);
                if (ref == NO_ICON) {
                    return null;
                }
                if (ref != null) {
                    img = (Image)ref.get();
                }
                if (img != null) {
                    return img;
                }
                if (name.startsWith("/")) {
                    warn = true;
                    n = name.substring(1);
                } else {
                    warn = false;
                    n = name;
                }
                URL url = loader != null ? loader.getResource(n) : IconManager.class.getClassLoader().getResource(n);
                result = null;
                try {
                    if (url == null) break block20;
                    if (name.endsWith(".png")) {
                        ImageInputStream stream = ImageIO.createImageInputStream(url.openStream());
                        ImageReadParam param = PNG_READER.getDefaultReadParam();
                        try {
                            PNG_READER.setInput(stream, true, true);
                            result = PNG_READER.read(0, param);
                        }
                        catch (IOException ioe1) {
                            ERR.log(Level.INFO, "Image " + name + " is not PNG", ioe1);
                        }
                        stream.close();
                    }
                    if (result == null) {
                        result = ImageIO.read(url);
                    }
                }
                catch (IOException ioe) {
                    ERR.log(Level.WARNING, "Cannot load " + name + " image", ioe);
                }
            }
            if (result != null) {
                if (warn && extraInitialSlashes.add(name)) {
                    ERR.warning("Initial slashes in Utilities.loadImage deprecated (cf. #20072): " + name);
                }
                ERR.log(Level.FINE, "loading icon {0} = {1}", new Object[]{n, result});
                name = new String(name).intern();
                cache.put(name, new ActiveRef<String>(result, cache, name));
                return result;
            }
            if (!localizedQuery) {
                cache.put(name, NO_ICON);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Image mergeImages(Image im1, Image im2, int x, int y) {
        CompositeImageKey k = new CompositeImageKey(im1, im2, x, y);
        Map<CompositeImageKey, ActiveRef<CompositeImageKey>> map = compositeCache;
        synchronized (map) {
            Image cached;
            ActiveRef<CompositeImageKey> r = compositeCache.get(k);
            if (r != null && (cached = (Image)r.get()) != null) {
                return cached;
            }
            cached = IconManager.doMergeImages(im1, im2, x, y);
            compositeCache.put(k, new ActiveRef<CompositeImageKey>(cached, compositeCache, k));
            return cached;
        }
    }

    static final Image toBufferedImage(Image img) {
        new ImageIcon(img, "");
        if (img.getHeight(null) * img.getWidth(null) > 576) {
            return img;
        }
        BufferedImage rep = IconManager.createBufferedImage(img.getWidth(null), img.getHeight(null));
        Graphics2D g = rep.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        img.flush();
        return rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLoaded(Image image) {
        if ((Toolkit.getDefaultToolkit().checkImage(image, -1, -1, null) & 0x30) != 0) {
            return;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            int id = ++mediaTrackerID;
            tracker.addImage(image, id);
            try {
                tracker.waitForID(id, 0L);
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED while loading Image");
            }
            assert (tracker.statusID(id, false) == 8) : "Image loaded";
            tracker.removeImage(image, id);
        }
    }

    private static final Image doMergeImages(Image image1, Image image2, int x, int y) {
        IconManager.ensureLoaded(image1);
        IconManager.ensureLoaded(image2);
        int w = Math.max(image1.getWidth(null), x + image2.getWidth(null));
        int h = Math.max(image1.getHeight(null), y + image2.getHeight(null));
        boolean bitmask = image1 instanceof Transparency && ((Transparency)((Object)image1)).getTransparency() != 3 && image2 instanceof Transparency && ((Transparency)((Object)image2)).getTransparency() != 3;
        ColorModel model = IconManager.colorModel(bitmask ? 2 : 3);
        BufferedImage buffImage = new BufferedImage(model, model.createCompatibleWritableRaster(w, h), model.isAlphaPremultiplied(), null);
        Graphics2D g = buffImage.createGraphics();
        g.drawImage(image1, 0, 0, null);
        g.drawImage(image2, x, y, null);
        g.dispose();
        return buffImage;
    }

    static final BufferedImage createBufferedImage(int width, int height) {
        if (Utilities.isMac()) {
            return new BufferedImage(width, height, 3);
        }
        ColorModel model = IconManager.colorModel(3);
        BufferedImage buffImage = new BufferedImage(model, model.createCompatibleWritableRaster(width, height), model.isAlphaPremultiplied(), null);
        return buffImage;
    }

    private static ColorModel colorModel(int transparency) {
        ColorModel model;
        try {
            model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(transparency);
        }
        catch (HeadlessException he) {
            model = ColorModel.getRGBdefault();
        }
        return model;
    }

    static {
        loaderQuery = null;
        noLoaderWarned = false;
        component = new Component(){};
        tracker = new MediaTracker(component);
        ERR = Logger.getLogger(IconManager.class.getName());
        ImageIO.setUseCache(false);
        PNG_READER = ImageIO.getImageReadersByMIMEType("image/png").next();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ActiveRef<T>
    extends SoftReference<Image>
    implements Runnable {
        private Map<T, ActiveRef<T>> holder;
        private T key;

        public ActiveRef(Image o, Map<T, ActiveRef<T>> holder, T key) {
            super(o, Utilities.activeReferenceQueue());
            this.holder = holder;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<T, ActiveRef<T>> map = this.holder;
            synchronized (map) {
                this.holder.remove(this.key);
            }
        }
    }

    private static class CompositeImageKey {
        Image baseImage;
        Image overlayImage;
        int x;
        int y;

        CompositeImageKey(Image base, Image overlay, int x, int y) {
            this.x = x;
            this.y = y;
            this.baseImage = base;
            this.overlayImage = overlay;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CompositeImageKey)) {
                return false;
            }
            CompositeImageKey k = (CompositeImageKey)other;
            return this.x == k.x && this.y == k.y && this.baseImage == k.baseImage && this.overlayImage == k.overlayImage;
        }

        public int hashCode() {
            int hash = (this.x << 3 ^ this.y) << 4;
            hash = hash ^ this.baseImage.hashCode() ^ this.overlayImage.hashCode();
            return hash;
        }

        public String toString() {
            return "Composite key for " + this.baseImage + " + " + this.overlayImage + " at [" + this.x + ", " + this.y + "]";
        }
    }
}

