/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.xdrpc;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.servlet.http.HttpServletRequest;
import org.openqa.selenium.remote.server.xdrpc.CrossDomainRpc;

public class HttpServletRequestProxy
implements InvocationHandler {
    private final HttpServletRequest proxiedRequest;
    private final CrossDomainRpc crossDomainRpc;
    private final String xdrpcPath;
    private final String mimeType;

    private HttpServletRequestProxy(HttpServletRequest proxiedRequest, CrossDomainRpc crossDomainRpc, String xdrpcPath, String mimeType) {
        this.proxiedRequest = proxiedRequest;
        this.crossDomainRpc = crossDomainRpc;
        this.xdrpcPath = xdrpcPath;
        this.mimeType = mimeType;
    }

    public static HttpServletRequest createProxy(HttpServletRequest request, CrossDomainRpc crossDomainRpc, String xdrpcPath, String mimeType) {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(crossDomainRpc);
        Preconditions.checkNotNull(xdrpcPath);
        Preconditions.checkNotNull(mimeType);
        return (HttpServletRequest)Proxy.newProxyInstance(request.getClass().getClassLoader(), request.getClass().getInterfaces(), (InvocationHandler)new HttpServletRequestProxy(request, crossDomainRpc, xdrpcPath, mimeType));
    }

    private String trimCrossDomainRpcPath(String str) {
        return str.substring(0, str.indexOf(this.xdrpcPath));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String headerName;
        if ("getMethod".equals(method.getName())) {
            return this.crossDomainRpc.getMethod();
        }
        if ("getRequestURL".equals(method.getName())) {
            String realUrl = this.proxiedRequest.getRequestURL().toString();
            return new StringBuffer().append(this.trimCrossDomainRpcPath(realUrl)).append(this.crossDomainRpc.getPath());
        }
        if ("getRequestURI".equals(method.getName())) {
            return String.valueOf(this.trimCrossDomainRpcPath(this.proxiedRequest.getRequestURI())) + this.crossDomainRpc.getPath();
        }
        if ("getPathInfo".equals(method.getName())) {
            return this.crossDomainRpc.getPath();
        }
        if ("getReader".equals(method.getName())) {
            return this.crossDomainRpc.getDataReader();
        }
        if ("getHeader".equals(method.getName()) && "accept".equalsIgnoreCase(headerName = (String)args[0])) {
            return this.mimeType;
        }
        try {
            return method.invoke((Object)this.proxiedRequest, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }
}

