/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.sh.utility;

import fitlibrary.exception.FitLibraryException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class QueueLinesFromStream
implements Runnable {
    private BufferedReader output;
    private BlockingQueue<String> lines = new LinkedBlockingQueue<String>();

    public QueueLinesFromStream(InputStream output) {
        this.output = new BufferedReader(new InputStreamReader(output));
    }

    public String take(long timeout, TimeUnit unit) throws InterruptedException {
        String line = this.lines.poll(timeout, unit);
        if (line == null) {
            throw new FitLibraryException("Timed out");
        }
        return line.trim().replaceAll("\\t", "").replaceAll("\\r", "").replaceAll("\\ \\ ", " ");
    }

    public String outputRemaining() throws InterruptedException {
        String result = "";
        while (!this.lines.isEmpty()) {
            result = String.valueOf(result) + this.lines.take() + "\n";
        }
        return result;
    }

    public String findFirstMatchingLineWaitingFor(String pattern, long timeout, TimeUnit unit) throws InterruptedException {
        String line;
        do {
            line = this.take(timeout, unit);
        } while (!Pattern.compile(pattern, 32).matcher(line).matches());
        return line;
    }

    @Override
    public void run() {
        while (true) {
            try {
                String line;
                while ((line = this.output.readLine()) != null) {
                    this.lines.add(line);
                }
            }
            catch (IOException e) {
                this.lines.add("Problem: " + e);
                continue;
            }
            break;
        }
    }
}

