/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider.component;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.spider.SpiderFixture;
import fitlibrary.spider.driver.DriverVariation;
import fitlibrary.spider.polling.PollForMatches;
import fitlibrary.spider.polling.PollForWithError;
import org.openqa.selenium.WebDriver;

public abstract class SpiderComponent {
    protected final SpiderFixture spiderFixture;

    public SpiderComponent(SpiderFixture spiderFixture) {
        this.spiderFixture = spiderFixture;
    }

    protected WebDriver webDriver() {
        return this.spiderFixture.webDriver();
    }

    protected DriverVariation driverVariation() {
        return this.spiderFixture.getDriverVariation();
    }

    protected boolean ensureMatches(PollForMatches poll) {
        return this.spiderFixture.ensureMatches(poll);
    }

    protected boolean ensureMatchesNoException(PollForMatches poll) {
        return this.spiderFixture.ensureMatchesNoException(poll);
    }

    protected FitLibraryException problem(String message, String details) {
        return this.spiderFixture.problem(message, details);
    }

    protected void showAfterTable(String s) {
        this.spiderFixture.showAfterTable(s);
    }

    protected void ensureWithError(PollForWithError poll, String timeoutName) {
        this.spiderFixture.ensureWithError(poll, this.spiderFixture.getTimeout(timeoutName));
    }
}

