/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ws.mock.requestMatcher;

import fitlibrary.mockWebServices.requestMatcher.AcceptAnyRequestMatcher;
import fitlibrary.mockWebServices.requestMatcher.RequestMatcher;
import fitlibrary.mockWebServices.requestMatcher.XmlRequestMatcher;
import fitlibrary.ws.message.Message;
import fitlibrary.ws.message.ReplyMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TestXmlRequestMatcher {
    private static final String XML = "<a>B</a>";
    private static final Message XML_REQUEST = TestXmlRequestMatcher.msg("<a>B</a>");
    private static final String XML_WITH_WHITESPACE = "\n<a>\n B </a>";
    private static final String WRONG_XML = "<a>BC</a>";
    private static final Message WRONG_XML_REQUEST = TestXmlRequestMatcher.msg("<a>BC</a>");
    private RequestMatcher matcher = new XmlRequestMatcher("<a>B</a>");
    private RequestMatcher matcherWithWhiteSpace = new XmlRequestMatcher("\n<a>\n B </a>");

    @Test
    public void matches() throws Exception {
        Assert.assertThat((Object)this.matcher.match(XML_REQUEST), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.matcher.match(TestXmlRequestMatcher.msg(XML_WITH_WHITESPACE)), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.matcherWithWhiteSpace.match(XML_REQUEST), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.matcherWithWhiteSpace.match(TestXmlRequestMatcher.msg(XML_WITH_WHITESPACE)), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void mismatches() throws Exception {
        Assert.assertThat((Object)this.matcher.match(WRONG_XML_REQUEST), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)this.matcherWithWhiteSpace.match(WRONG_XML_REQUEST), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void and() throws Exception {
        AcceptAnyRequestMatcher acceptAnyRequestMatcher = new AcceptAnyRequestMatcher();
        Assert.assertThat((Object)this.matcherWithWhiteSpace.and(acceptAnyRequestMatcher).match(XML_REQUEST), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.matcherWithWhiteSpace.and(acceptAnyRequestMatcher).match(WRONG_XML_REQUEST), (Matcher)Matchers.equalTo((Object)false));
    }

    private static ReplyMessage msg(String string) {
        return new ReplyMessage(string);
    }
}

