/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ws.mock.term;

import fitlibrary.mockWebServices.responder.ErrorResponder;
import fitlibrary.mockWebServices.responder.LiteralResponder;
import fitlibrary.mockWebServices.responder.Responder;
import fitlibrary.mockWebServices.term.CompositeTerm;
import fitlibrary.mockWebServices.term.OrTerm;
import fitlibrary.mockWebServices.term.Term;
import fitlibrary.ws.message.ContentType;
import fitlibrary.ws.message.Message;
import fitlibrary.ws.message.ReplyMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestOrTerm {
    final Mockery context = new JUnit4Mockery();
    static final Responder ERROR = ErrorResponder.create();
    static final Responder SOME = new LiteralResponder("aa", ContentType.PLAIN);
    final Term t1 = (Term)this.context.mock(Term.class, "term1");
    final Term t2 = (Term)this.context.mock(Term.class, "term2");
    final Message request = TestOrTerm.msg("request");

    @Test
    public void emptySequence() throws Exception {
        OrTerm orTerm = new OrTerm(new Term[0]);
        Assert.assertThat((Object)orTerm.matchRequest(this.request), (Matcher)Matchers.equalTo((Object)ERROR));
    }

    @Test
    public void allUsed() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Term)this.one(TestOrTerm.this.t1)).setComposite((Term)this.with(1.any(CompositeTerm.class)));
                ((Term)this.one(TestOrTerm.this.t1)).available();
                this.will(1.returnValue((Object)false));
                ((Term)this.one(TestOrTerm.this.t2)).setComposite((Term)this.with(1.any(CompositeTerm.class)));
                ((Term)this.one(TestOrTerm.this.t2)).available();
                this.will(1.returnValue((Object)false));
            }
        });
        Assert.assertThat((Object)this.term(this.t1, this.t2).matchRequest(this.request), (Matcher)Matchers.equalTo((Object)ERROR));
    }

    @Test
    public void noMatch() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Term)this.one(TestOrTerm.this.t1)).setComposite((Term)this.with(2.any(CompositeTerm.class)));
                ((Term)this.one(TestOrTerm.this.t2)).setComposite((Term)this.with(2.any(CompositeTerm.class)));
                ((Term)this.one(TestOrTerm.this.t1)).available();
                this.will(2.returnValue((Object)true));
                ((Term)this.one(TestOrTerm.this.t1)).matchRequest(TestOrTerm.this.request);
                this.will(2.returnValue((Object)ERROR));
                ((Term)this.one(TestOrTerm.this.t2)).available();
                this.will(2.returnValue((Object)true));
                ((Term)this.one(TestOrTerm.this.t2)).matchRequest(TestOrTerm.this.request);
                this.will(2.returnValue((Object)ERROR));
            }
        });
        Assert.assertThat((Object)this.term(this.t1, this.t2).matchRequest(this.request), (Matcher)Matchers.equalTo((Object)ERROR));
    }

    @Test
    public void firstMatch() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Term)this.one(TestOrTerm.this.t1)).setComposite((Term)this.with(3.any(CompositeTerm.class)));
                ((Term)this.one(TestOrTerm.this.t2)).setComposite((Term)this.with(3.any(CompositeTerm.class)));
                ((Term)this.one(TestOrTerm.this.t1)).available();
                this.will(3.returnValue((Object)true));
                ((Term)this.one(TestOrTerm.this.t1)).matchRequest(TestOrTerm.this.request);
                this.will(3.returnValue((Object)SOME));
            }
        });
        Assert.assertThat((Object)this.term(this.t1, this.t2).matchRequest(this.request), (Matcher)Matchers.equalTo((Object)SOME));
    }

    @Test
    public void secondMatch() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Term)this.one(TestOrTerm.this.t1)).setComposite((Term)this.with(4.any(CompositeTerm.class)));
                ((Term)this.one(TestOrTerm.this.t2)).setComposite((Term)this.with(4.any(CompositeTerm.class)));
                ((Term)this.one(TestOrTerm.this.t1)).available();
                this.will(4.returnValue((Object)false));
                ((Term)this.one(TestOrTerm.this.t2)).available();
                this.will(4.returnValue((Object)true));
                ((Term)this.one(TestOrTerm.this.t2)).matchRequest(TestOrTerm.this.request);
                this.will(4.returnValue((Object)SOME));
            }
        });
        Assert.assertThat((Object)this.term(this.t1, this.t2).matchRequest(this.request), (Matcher)Matchers.equalTo((Object)SOME));
    }

    @Test
    public void bothMatch() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Term)this.one(TestOrTerm.this.t1)).setComposite((Term)this.with(5.any(CompositeTerm.class)));
                ((Term)this.one(TestOrTerm.this.t2)).setComposite((Term)this.with(5.any(CompositeTerm.class)));
                ((Term)this.one(TestOrTerm.this.t1)).available();
                this.will(5.returnValue((Object)true));
                ((Term)this.one(TestOrTerm.this.t1)).matchRequest(TestOrTerm.this.request);
                this.will(5.returnValue((Object)SOME));
            }
        });
        Assert.assertThat((Object)this.term(this.t1, this.t2).matchRequest(this.request), (Matcher)Matchers.equalTo((Object)SOME));
    }

    private Term term(Term term, Term term2) {
        return new OrTerm(term, term2);
    }

    private static ReplyMessage msg(String string) {
        return new ReplyMessage(string);
    }
}

