/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrthogonalRepresentation {
    private Map<Face, OrthogonalShape> shapes = new LinkedHashMap<Face, OrthogonalShape>();
    private EmbeddedPlanarGraph originalGraph;
    private MGraph.Vertex cornerVertex;

    public static OrthogonalRepresentation createGraph(EmbeddedPlanarGraph graph) {
        return new OrthogonalRepresentation(graph);
    }

    private OrthogonalRepresentation(EmbeddedPlanarGraph graph) {
        this.originalGraph = graph;
    }

    public EmbeddedPlanarGraph getOriginalGraph() {
        return this.originalGraph;
    }

    public OrthogonalShape getShape(Face face) {
        OrthogonalShape shape = this.shapes.get(face);
        if (shape == null) {
            shape = new OrthogonalShape(face);
            this.shapes.put(face, shape);
        }
        return shape;
    }

    public Collection<OrthogonalShape> getShapes() {
        return this.shapes.values();
    }

    public void setCornerVertex(MGraph.Vertex cornerVertex) {
        this.cornerVertex = cornerVertex;
    }

    public MGraph.Vertex getCornerVertex() {
        return this.cornerVertex;
    }

    public String toString() {
        String s = "Orthogonal Representation:\n";
        for (OrthogonalShape shape : this.shapes.values()) {
            s = s + shape;
        }
        return s;
    }

    public class Tuple {
        private Face.Dart dart;
        private BitSet bends;
        private int angles;

        public Tuple(Face.Dart dart) {
            this.dart = dart;
            this.bends = new BitSet();
        }

        public Face.Dart getDart() {
            return this.dart;
        }

        public BitSet getBends() {
            return this.bends;
        }

        public int getNumberOfBends() {
            int length = this.bends.length();
            if (length > 0) {
                --length;
            }
            return length;
        }

        public int getAngles() {
            return this.angles;
        }

        public void setAngles(int angles) {
            if (angles == 0) {
                new Exception().printStackTrace();
            }
            this.angles = angles;
        }

        public String toString() {
            String s = "Tuple:\n";
            s = s + this.dart + "\n";
            s = s + "angles = " + this.angles + "\n";
            s = s + "bends = " + this.bends + "\n";
            s = s + "# of bends = " + this.getNumberOfBends() + "\n";
            s = s + "direction = " + (Object)((Object)this.dart.getEdge().getDirection()) + "\n";
            return s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OrthogonalShape {
        private Map<Face.Dart, Tuple> tupleMap;
        private Face face;

        OrthogonalShape(Face face) {
            this.face = face;
            this.tupleMap = new LinkedHashMap<Face.Dart, Tuple>();
            for (Face.Dart d : face.getDarts()) {
                Tuple t = new Tuple(d);
                this.tupleMap.put(d, t);
            }
        }

        public Face getFace() {
            return this.face;
        }

        public Tuple getTuple(Face.Dart dart) {
            return this.tupleMap.get(dart);
        }

        public void updateTuple(Tuple tuple, Collection<MGraph.Edge> newEdges) {
            Face.Dart originalDart = tuple.getDart();
            MGraph.Edge originalEdge = originalDart.getEdge();
            List<Face.Dart> newDarts = this.face.replaceDart(originalDart, newEdges);
            this.tupleMap.remove(originalDart);
            BitSet bends = tuple.getBends();
            int size = newDarts.size();
            for (int i = 0; i < size; ++i) {
                Face.Dart newDart = newDarts.get(i);
                Tuple newTuple = new Tuple(newDart);
                this.tupleMap.put(newDart, newTuple);
                if (i == 0) {
                    newTuple.setAngles(tuple.getAngles());
                    continue;
                }
                if (bends.length() > 0) {
                    boolean bit = bends.get(i - 1);
                    if (bit) {
                        newTuple.setAngles(3);
                        continue;
                    }
                    newTuple.setAngles(1);
                    continue;
                }
                newTuple.setAngles(2);
            }
            Face.Dart reverseDart = this.face.getDart(originalEdge);
            if (reverseDart != null) {
                Tuple reverseTuple = this.getTuple(reverseDart);
                this.updateTuple(reverseTuple, newEdges);
            }
        }

        public void insertEdge(MGraph.Edge edge) {
            List<Face.Dart> removedDarts = this.face.replaceDarts(edge);
            if (removedDarts.isEmpty()) {
                return;
            }
            for (Face.Dart d : removedDarts) {
                this.tupleMap.remove(d);
            }
            Face.Dart newDart = this.face.getDart(edge);
            Tuple newTuple = new Tuple(newDart);
            this.tupleMap.put(newDart, newTuple);
            newTuple.setAngles(1);
            Face.Dart nextDart = this.face.getNextDart(newDart);
            Tuple nextTuple = this.getTuple(nextDart);
            nextTuple.setAngles(2);
        }

        public String toString() {
            String s = "Shape:\n";
            s = s + this.face;
            return s;
        }
    }
}

