/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.build;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.build.AbstractBuckminsterBuilder;
import org.eclipse.buckminster.core.helpers.AccessibleByteArrayOutputStream;
import org.eclipse.buckminster.core.helpers.BMProperties;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class PropertiesEmitter
extends AbstractBuckminsterBuilder
implements IResourceChangeListener {
    public static final String ARG_FILE = "file";
    public static final String ARG_FILE_SEPARATOR = "file.separator";
    public static final String ARG_TRUNCATE = "truncate";
    public static final String DEFAULT_PROPERTY_FILE = "buckminster.properties";
    private Map<String, String> arguments;
    private HashMap<String, Format> formatters;
    private Map<String, String> properties;
    private IFile propertyFile;

    public void doStartupOnIntialize() throws CoreException {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    @Override
    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 1 || this.propertyFile == null) {
            return;
        }
        IResourceDelta propFileDelta = event.getDelta().findMember(this.propertyFile.getFullPath());
        if (propFileDelta != null && (propFileDelta.getKind() & 2) != 0) {
            this.forgetLastBuiltState();
        }
    }

    protected void addFormat(String argKey, Format defaultFormat) {
        String arg = this.getArgument(argKey);
        this.formatters.put(argKey, arg == null ? defaultFormat : new MessageFormat(arg));
    }

    protected abstract void addFormatters();

    protected void addProperty(String formatKey, String[] keyArgs, String value) {
        this.properties.put(this.formatters.get(formatKey).format(keyArgs), value);
    }

    protected abstract void appendProperties() throws CoreException;

    @Override
    protected IProject[] doAutoBuild(Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        return this.doFullBuild(args, monitor);
    }

    @Override
    protected IProject[] doCleanBuild(Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (this.propertyFile != null) {
            monitor.beginTask(String.valueOf(Messages.Deleting) + this.propertyFile, 100);
            this.propertyFile.refreshLocal(0, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            if (this.propertyFile.exists()) {
                this.propertyFile.delete(false, false, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            }
            monitor.done();
        }
        return null;
    }

    @Override
    protected IProject[] doFullBuild(Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        this.arguments = args;
        this.formatters = new HashMap();
        String propertyFileName = this.getArgument(ARG_FILE);
        if (propertyFileName == null) {
            propertyFileName = DEFAULT_PROPERTY_FILE;
        }
        this.propertyFile = this.getProject().getFile(propertyFileName);
        boolean truncate = Boolean.parseBoolean(this.getArgument(ARG_TRUNCATE));
        int ticks = 5;
        if (!truncate) {
            ticks += 2;
        }
        monitor.beginTask(null, ticks);
        monitor.subTask(Messages.Emitting_properties);
        this.propertyFile.refreshLocal(0, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
        BMProperties oldProps = null;
        if (this.propertyFile.exists()) {
            BufferedInputStream recentProperties = null;
            try {
                try {
                    recentProperties = new BufferedInputStream(this.propertyFile.getContents());
                    oldProps = new BMProperties(recentProperties);
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)2);
                }
                catch (IOException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(recentProperties);
                throw throwable;
            }
            IOUtils.close((Closeable)recentProperties);
        }
        this.properties = new HashMap<String, String>();
        if (!truncate && oldProps != null) {
            this.properties.putAll(oldProps);
        }
        this.addFormatters();
        try {
            try {
                this.appendProperties();
                MonitorUtils.worked((IProgressMonitor)monitor, (int)2);
                AccessibleByteArrayOutputStream output = new AccessibleByteArrayOutputStream();
                BMProperties.store(this.properties, output, Messages.Generated_by_Buckminster_Do_not_edit);
                if (oldProps != null) {
                    if (!this.properties.equals(oldProps)) {
                        this.propertyFile.setContents(output.getInputStream(), false, false, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                        this.propertyFile.setDerived(true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                    } else {
                        MonitorUtils.worked((IProgressMonitor)monitor, (int)2);
                    }
                } else {
                    FileUtils.createFolder(this.propertyFile.getParent());
                    this.propertyFile.create(output.getInputStream(), false, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                    this.propertyFile.setDerived(true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                }
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        finally {
            monitor.done();
            this.arguments = null;
            this.formatters = null;
            this.properties = null;
        }
        return null;
    }

    @Override
    protected IProject[] doIncrementalBuild(Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        return this.doFullBuild(args, monitor);
    }

    protected final String formatPath(IPath path) {
        String filesep = this.getArgument(ARG_FILE_SEPARATOR);
        if (filesep == null || filesep.length() == 0) {
            return path.toOSString();
        }
        String portable = path.toPortableString();
        if (filesep.equals("/")) {
            return portable;
        }
        return portable.replace('/', filesep.charAt(0));
    }

    protected final String getArgument(String key) {
        return this.arguments == null ? null : this.arguments.get(key);
    }
}

