/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.runtime.preferences.PreferenceFilterEntry;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractPreferencesCommand
extends WorkspaceCommand {
    private static final OptionDescriptor SCOPE_OPTION = new OptionDescriptor('S', "scope", 3);
    private static final OptionDescriptor FILE_OPTION = new OptionDescriptor('F', "file", 3);
    private IScopeContext scope;
    private HashMap<String, ArrayList<PreferenceFilterEntry>> includes;
    private File prefsFile;

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(SCOPE_OPTION);
        appendHere.add(FILE_OPTION);
        super.getOptionDescriptors(appendHere);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleOption(Option option) throws Exception {
        if (option.is(SCOPE_OPTION)) {
            if (this.scope != null) {
                throw new UsageException(Messages.Only_one_scope_can_be_given);
            }
            String scopeName = option.getValue();
            if (scopeName.equalsIgnoreCase("instance")) {
                this.scope = InstanceScope.INSTANCE;
                return;
            } else {
                if (!scopeName.equalsIgnoreCase("configuration")) throw new UsageException(NLS.bind((String)Messages.Invalid_scope_Valid_scopes_are_0_and_1, (Object)"configuration", (Object)"instance"));
                this.scope = ConfigurationScope.INSTANCE;
            }
            return;
        } else if (option.is(FILE_OPTION)) {
            if (this.prefsFile != null) {
                throw new UsageException(Messages.Only_one_file_can_be_given);
            }
            this.prefsFile = new File(option.getValue());
            return;
        } else {
            super.handleOption(option);
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        if (unparsed.length == 0) {
            return;
        }
        if (this.includes == null) {
            this.includes = new HashMap();
        }
        int idx = 0;
        while (idx < unparsed.length) {
            String include = unparsed[idx];
            String rootKey = null;
            String[] subKeys = null;
            int sepIdx = include.indexOf(35);
            if (sepIdx < 0 || sepIdx >= 1) {
                if (sepIdx < 0) {
                    rootKey = include.trim();
                } else {
                    rootKey = include.substring(0, sepIdx).trim();
                    subKeys = include.substring(sepIdx + 1).split(",");
                    if (subKeys.length == 0) {
                        subKeys = null;
                    }
                }
            }
            if (rootKey == null || rootKey.length() == 0) {
                throw new UsageException(NLS.bind((String)Messages.Illegal_include_0_Must_be_in_the_form, (Object)include));
            }
            if (subKeys == null) {
                this.includes.put(rootKey, null);
            } else {
                ArrayList<Object> pfes = this.includes.get(rootKey);
                if (pfes == null) {
                    pfes = new ArrayList();
                }
                int subIdx = 0;
                while (subIdx < subKeys.length) {
                    String subKey = subKeys[subIdx];
                    if ((subKey = subKey.trim()).length() != 0) {
                        pfes.add(new PreferenceFilterEntry(subKey));
                        if (!subKey.startsWith(rootKey)) {
                            pfes.add(new PreferenceFilterEntry(String.valueOf(rootKey) + '.' + subKey));
                        }
                    }
                    ++subIdx;
                }
                if (pfes.size() > 0) {
                    this.includes.put(rootKey, pfes);
                }
            }
            ++idx;
        }
    }

    File getFile() {
        return this.prefsFile;
    }

    IPreferenceFilter[] getFilter() {
        HashMap<String, PreferenceFilterEntry[]> pfess = null;
        if (this.includes != null) {
            pfess = new HashMap<String, PreferenceFilterEntry[]>();
            for (Map.Entry<String, ArrayList<PreferenceFilterEntry>> entry : this.includes.entrySet()) {
                ArrayList<PreferenceFilterEntry> pfes = entry.getValue();
                if (pfes != null) {
                    pfess.put(entry.getKey(), pfes.toArray(new PreferenceFilterEntry[pfes.size()]));
                    continue;
                }
                pfess.put(entry.getKey(), null);
            }
        }
        PreferenceFilter filter = this.scope == null ? new PreferenceFilter(new String[]{"instance", "configuration"}, pfess) : new PreferenceFilter(new String[]{this.scope.getName()}, pfess);
        return new IPreferenceFilter[]{filter};
    }

    IEclipsePreferences getNode() {
        IPreferencesService prefService = Platform.getPreferencesService();
        IEclipsePreferences node = this.scope == null ? prefService.getRootNode() : (IEclipsePreferences)prefService.getRootNode().node(this.scope.getName());
        return node;
    }

    class PreferenceFilter
    implements IPreferenceFilter {
        private final String[] scopes;
        private final Map<String, PreferenceFilterEntry[]> mapping;

        PreferenceFilter(String[] scopes, Map<String, PreferenceFilterEntry[]> mapping) {
            this.scopes = scopes;
            this.mapping = mapping;
        }

        public Map<String, PreferenceFilterEntry[]> getMapping(String s) {
            return this.mapping;
        }

        public String[] getScopes() {
            return this.scopes;
        }
    }
}

