/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.model;

import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.ValueHolder;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PropertyRef<T>
extends ValueHolder<T> {
    public static final String TAG = "propertyRef";
    public static final String ATTR_KEY = "key";
    private final Class<T> refClass;
    private final String key;

    public PropertyRef(Class<T> refClass, String key) {
        this.key = key;
        this.refClass = refClass;
    }

    @Override
    public T checkedGetValue(Map<String, ? extends Object> properties, int recursionGuard) {
        String expandedKey = ExpandingProperties.expand(properties, this.key, recursionGuard + 1);
        if (properties instanceof ExpandingProperties) {
            return this.refClass.cast(((ExpandingProperties)properties).getExpandedProperty(expandedKey, recursionGuard + 1));
        }
        Object replacementValue = properties.get(expandedKey);
        if (replacementValue == null) {
            CorePlugin.getLogger().warning(NLS.bind((String)Messages.The_property_0_has_not_been_set_and_will_default_to_null, (Object)this.key), new Object[0]);
        }
        return this.refClass.cast(ExpandingProperties.expand(properties, replacementValue, recursionGuard + 1));
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Trivial.equalsAllowNull((Object)this.key, (Object)((PropertyRef)((Object)o)).key);
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public int hashCode() {
        int hc = super.hashCode();
        hc = 37 * hc + (this.key == null ? 0 : this.key.hashCode());
        return hc;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_KEY, (String)this.key);
    }
}

