/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.core.common.model.RxAssembly;
import org.eclipse.buckminster.core.common.model.RxPart;
import org.eclipse.buckminster.core.common.parser.RxGroupHandler;
import org.eclipse.buckminster.core.common.parser.RxPartHandler;
import org.eclipse.buckminster.core.common.parser.RxPatternHandler;
import org.eclipse.buckminster.core.common.parser.TaggedRxPatternHandler;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RxAssemblyHandler
extends ExtensionAwareHandler
implements ChildPoppedListener {
    private final HashMap<String, RxPartHandler> partHandlers = new HashMap();
    private ArrayList<RxPart> parts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RxPartHandler getPartHandler(ExtensionAwareHandler parent, String localName, Map<String, RxPartHandler> handlerCache) {
        Map<String, RxPartHandler> map = handlerCache;
        synchronized (map) {
            RxPartHandler ch = handlerCache.get(localName);
            if (ch != null) {
                return ch;
            }
            ch = "group".equals(localName) ? new RxGroupHandler((AbstractHandler)parent) : ("match".equals(localName) ? new RxPatternHandler((AbstractHandler)parent) : new TaggedRxPatternHandler((AbstractHandler)parent, localName));
            handlerCache.put(localName, ch);
            return ch;
        }
    }

    public RxAssemblyHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (child instanceof RxPartHandler) {
            if (this.parts == null) {
                this.parts = new ArrayList();
            }
            this.parts.add(((RxPartHandler)child).createPart());
        }
    }

    public RxAssembly createAssembly() throws SAXException {
        try {
            return new RxAssembly(this.parts);
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), e);
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        return RxAssemblyHandler.getPartHandler(this, localName, this.partHandlers);
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.parts = null;
    }

    protected ArrayList<RxPart> getParts() {
        return this.parts;
    }
}

