/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.Map;
import org.eclipse.buckminster.core.cspec.IActionArtifact;
import org.eclipse.buckminster.core.cspec.builder.ActionArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.Artifact;
import org.eclipse.buckminster.core.cspec.model.MissingAttributeException;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.helpers.AttributesImpl;

public class ActionArtifact
extends Artifact
implements IActionArtifact {
    private final String actionName;
    private final String alias;

    public ActionArtifact(ActionArtifactBuilder builder) {
        super(builder);
        this.actionName = builder.getActionName();
        this.alias = builder.getAlias();
    }

    public final Action getAction() throws MissingAttributeException {
        return (Action)this.getCSpec().getRequiredAttribute(this.actionName);
    }

    @Override
    public String getActionName() {
        return this.actionName;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public boolean isEnabled(IModelCache ctx) throws CoreException {
        return this.getAction().isEnabled(ctx);
    }

    @Override
    public boolean isProducedByActions(IModelCache ctx) {
        return true;
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        if (this.alias != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"alias", (String)this.alias);
        }
    }

    @Override
    protected AttributeBuilder createAttributeBuilder(CSpecBuilder cspecBuilder) {
        return cspecBuilder.createActionArtifactBuilder();
    }

    @Override
    protected IPath getExpandedBase(Map<String, ? extends Object> local) throws CoreException {
        return this.getAction().getExpandedBase(this.getBase(), local);
    }
}

