/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IAttributeFilter;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.NamedElement;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Attribute
extends NamedElement
implements Cloneable,
IAttribute {
    public static final String TAG = "define";
    public static final String ATTR_FILTER = "filter";
    private final Documentation documentation;
    private final Filter filter;
    private CSpec cspec;

    public Attribute(AttributeBuilder builder) {
        super(builder.getName());
        this.documentation = builder.getDocumentation();
        this.filter = builder.getFilter();
    }

    Attribute(String name) {
        super(name);
        this.documentation = null;
        this.filter = null;
    }

    public void addDynamicProperties(Map<String, Object> properties) throws CoreException {
    }

    public IAttribute copy() {
        Attribute copy;
        try {
            copy = (Attribute)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        copy.cspec = null;
        return copy;
    }

    @Override
    public AttributeBuilder getAttributeBuilder(CSpecBuilder cspecBuilder) {
        AttributeBuilder bld = this.createAttributeBuilder(cspecBuilder);
        bld.initFrom(this);
        return bld;
    }

    public final CSpec getCSpec() {
        assert (this.cspec != null);
        return this.cspec;
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public Documentation getDocumentation() {
        return this.documentation;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    public PathGroup[] getPathGroups(IModelCache ctx, Stack<IAttributeFilter> filters) throws CoreException {
        return PathGroup.EMPTY_ARRAY;
    }

    public List<Prerequisite> getPrerequisites() {
        return this.getPrerequisites(null);
    }

    public List<Prerequisite> getPrerequisites(Stack<IAttributeFilter> filters) {
        return Collections.emptyList();
    }

    @Override
    public String getQualifiedName() {
        return String.valueOf(this.getCSpec().getComponentIdentifier().toString()) + '#' + this.getName();
    }

    public boolean isEnabled(IModelCache ctx) throws CoreException {
        return this.filter == null || this.filter.matchCase(ctx.getProperties());
    }

    public boolean isProducedByActions(IModelCache cache) throws CoreException {
        return false;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public final String toString() {
        StringBuilder bld = new StringBuilder();
        this.toString(bld);
        return bld.toString();
    }

    public void toString(StringBuilder bld) {
        this.getCSpec().getComponentIdentifier().toString(bld);
        bld.append('#');
        bld.append(this.getName());
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        if (this.filter != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_FILTER, (String)this.filter.toString());
        }
    }

    protected AttributeBuilder createAttributeBuilder(CSpecBuilder cspecBuilder) {
        return cspecBuilder.createAttributeBuilder();
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        if (this.documentation != null) {
            this.documentation.toSax(handler, namespace, prefix, this.documentation.getDefaultTag());
        }
    }

    void setCSPec(CSpec cspec) {
        this.cspec = cspec;
    }
}

