/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.Map;
import java.util.Stack;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IAttributeFilter;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.osgi.util.NLS;

public abstract class TopLevelAttribute
extends Attribute
implements Cloneable {
    public static final String PROPERTY_PREFIX = "buckminster.";
    public static final String INSTALLER_HINT_PREFIX = "buckminster.install.";
    public static final String PUBLIC_TAG = "public";
    public static final String PRIVATE_TAG = "private";
    public static final String DEFINITION_TAG = "definitions";
    public static final String DEFINE_TAG = "define";
    private final boolean publ;

    TopLevelAttribute(String name) {
        super(name);
        this.publ = true;
    }

    TopLevelAttribute(TopLevelAttributeBuilder builder) {
        super(builder);
        this.publ = builder.isPublic();
    }

    @Override
    public void addDynamicProperties(Map<String, Object> properties) throws CoreException {
        IPath tempRoot;
        String ctype;
        CSpec cspec = this.getCSpec();
        StringBuilder bld = new StringBuilder();
        bld.append(cspec.getName());
        Version version = cspec.getVersion();
        if (version != null) {
            bld.append('_');
            bld.append(VersionHelper.replaceQualifier(version, null));
        }
        if (!"unknown".equals(ctype = cspec.getComponentTypeID())) {
            bld.append('-');
            bld.append(cspec.getComponentTypeID());
        }
        String uniqueFolder = bld.toString();
        String tempRootStr = (String)properties.get("buckminster.temp.root");
        if (tempRootStr == null) {
            tempRoot = Path.fromOSString((String)System.getProperty("java.io.tmpdir")).append("buckminster");
            properties.put("buckminster.temp.root", tempRoot.toOSString());
        } else {
            tempRoot = Path.fromOSString((String)tempRootStr);
        }
        String actionTemp = tempRoot.append(uniqueFolder).append("temp").toPortableString();
        String outputRoot = (String)properties.get("buckminster.output.root");
        if (outputRoot == null) {
            outputRoot = tempRoot.append("build").toOSString();
        }
        String actionOutput = Path.fromOSString((String)outputRoot).append(uniqueFolder).toPortableString();
        properties.put("buckminster.output", actionOutput);
        properties.put("buckminster.temp", actionTemp);
        properties.put("buckminster.home", cspec.getComponentLocation().toOSString());
        properties.putAll(cspec.getComponentIdentifier().getProperties());
    }

    public void appendRelativeFiles(IModelCache ctx, Map<String, Long> fileNames) throws CoreException {
        PathGroup[] pqs = this.getPathGroups(ctx, null);
        int idx = pqs.length;
        while (--idx >= 0) {
            pqs[idx].appendRelativeFiles(fileNames);
        }
    }

    @Override
    public String getDefaultTag() {
        return this.isPublic() ? PUBLIC_TAG : PRIVATE_TAG;
    }

    public long getFirstModified(IModelCache ctx, int expectedFileCount, int[] fileCount) throws CoreException {
        PathGroup[] pqs = this.getPathGroups(ctx, null);
        int idx = pqs.length;
        if (idx == 0) {
            return 0L;
        }
        if (idx > 1 && expectedFileCount > 0) {
            expectedFileCount = -1;
        }
        long oldest = Long.MAX_VALUE;
        while (--idx >= 0) {
            long pgModTime = pqs[idx].getFirstModified(expectedFileCount, fileCount);
            if (pgModTime < oldest && (oldest = pgModTime) == 0L) break;
        }
        return oldest;
    }

    public long getLastModified(IModelCache ctx, long threshold, int[] fileCount) throws CoreException {
        PathGroup[] pqs = this.getPathGroups(ctx, null);
        int count = 0;
        int idx = pqs.length;
        int[] countBin = new int[1];
        long newest = 0L;
        while (--idx >= 0) {
            countBin[0] = 0;
            long pgModTime = pqs[idx].getLastModified(threshold, countBin);
            count += countBin[0];
            if (pgModTime > newest && (newest = pgModTime) > threshold) break;
        }
        fileCount[0] = count;
        return newest;
    }

    @Override
    public final PathGroup[] getPathGroups(IModelCache ctx, Stack<IAttributeFilter> filters) throws CoreException {
        PathGroup[] pga;
        if (filters == null || filters.isEmpty()) {
            String qName;
            Map<String, PathGroup[]> cache = ctx.getPathGroupsCache();
            pga = cache.get(qName = this.getQualifiedName());
            if (pga == null) {
                ExpandingProperties<Object> local = new ExpandingProperties<Object>(ctx.getProperties());
                this.addDynamicProperties(local);
                pga = this.internalGetPathGroups(ctx, local, filters);
                cache.put(qName, pga);
            }
        } else {
            ExpandingProperties<Object> local = new ExpandingProperties<Object>(ctx.getProperties());
            this.addDynamicProperties(local);
            pga = this.internalGetPathGroups(ctx, local, filters);
        }
        return pga;
    }

    public IPath getUniquePath(IPath root, IModelCache modelCtx) throws CoreException {
        PathGroup group;
        IPath[] paths;
        IPath uniquePath = null;
        PathGroup[] groups = this.getPathGroups(modelCtx, null);
        if (groups.length == 1 && (paths = (group = groups[0]).getPaths()).length == 1) {
            IPath base = group.getBase();
            if (base == null || !base.isAbsolute()) {
                if (root == null) {
                    root = this.getCSpec().getComponentLocation();
                }
                if (base == null) {
                    base = root;
                } else if (!base.isAbsolute()) {
                    base = root.append(base);
                }
            }
            uniquePath = base.append(paths[0]);
        }
        if (uniquePath == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Unable_to_determine_a_unique_product_path_for_0, (Object)this), (Object[])new Object[0]);
        }
        return uniquePath;
    }

    @Override
    public boolean isPublic() {
        return this.publ;
    }

    @Override
    protected abstract AttributeBuilder createAttributeBuilder(CSpecBuilder var1);

    protected abstract PathGroup[] internalGetPathGroups(IModelCache var1, Map<String, ? extends Object> var2, Stack<IAttributeFilter> var3) throws CoreException;
}

