/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.FileHandle;
import org.eclipse.buckminster.core.helpers.ShortDurationFileCache;
import org.eclipse.buckminster.runtime.FileInfoBuilder;
import org.eclipse.buckminster.runtime.IFileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

class CacheEntry {
    private int openFileCounter = 0;
    private boolean removePending = false;
    private FileHandle tempFile;
    private FileInfoBuilder fileInfo = null;

    CacheEntry() {
    }

    public synchronized void initialize(ShortDurationFileCache cache, ShortDurationFileCache.Materializer materializer, IProgressMonitor monitor, FileInfoBuilder info) throws CoreException, IOException {
        boolean success = false;
        try {
            if (this.tempFile == null) {
                this.tempFile = materializer.materialize(monitor, info);
                if (this.tempFile.isTemporary()) {
                    this.tempFile.getFile().deleteOnExit();
                }
                if (info != null) {
                    this.fileInfo = new FileInfoBuilder((IFileInfo)info);
                }
                cache.schedule(materializer.getKey());
            } else if (this.fileInfo != null && info != null) {
                this.fileInfo.initFrom((IFileInfo)info);
            }
            success = true;
        }
        finally {
            if (!success) {
                cache.remove(materializer.getKey());
            }
        }
    }

    public synchronized InputStream open() throws FileNotFoundException {
        if (this.removePending) {
            throw new FileNotFoundException(Messages.File_is_closed);
        }
        if (this.tempFile.isTemporary()) {
            ++this.openFileCounter;
            return new DeletingInputStream(this.tempFile.getFile());
        }
        return new FileInputStream(this.tempFile.getFile());
    }

    public final synchronized void remove() {
        if (this.openFileCounter > 0) {
            this.removePending = true;
        } else if (this.tempFile != null && this.tempFile.isTemporary() && !this.removePending) {
            this.removePending = true;
            this.tempFile.getFile().delete();
        }
    }

    class DeletingInputStream
    extends FileInputStream {
        DeletingInputStream(File file) throws FileNotFoundException {
            super(file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            catch (Throwable throwable) {
                CacheEntry cacheEntry = CacheEntry.this;
                synchronized (cacheEntry) {
                    CacheEntry cacheEntry2 = CacheEntry.this;
                    int n = cacheEntry2.openFileCounter - 1;
                    cacheEntry2.openFileCounter = n;
                    if (n < 1 && CacheEntry.this.removePending) {
                        CacheEntry.this.tempFile.getFile().delete();
                    }
                }
                throw throwable;
            }
            CacheEntry cacheEntry = CacheEntry.this;
            synchronized (cacheEntry) {
                CacheEntry cacheEntry3 = CacheEntry.this;
                int n = cacheEntry3.openFileCounter - 1;
                cacheEntry3.openFileCounter = n;
                if (n < 1 && CacheEntry.this.removePending) {
                    CacheEntry.this.tempFile.getFile().delete();
                }
            }
        }
    }
}

