/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.buckminster.core.helpers.CacheEntry;
import org.eclipse.buckminster.core.helpers.FileHandle;
import org.eclipse.buckminster.core.helpers.TimedHashMap;
import org.eclipse.buckminster.runtime.FileInfoBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ShortDurationFileCache
extends TimedHashMap<String, CacheEntry> {
    public ShortDurationFileCache(long keepAlive, String prefix, String suffix, File tempDir) {
        super(keepAlive, new TimedHashMap.EvictionPolicy<String, CacheEntry>(){

            @Override
            public void evict(Map.Entry<String, CacheEntry> entry) {
                CacheEntry ce = entry.getValue();
                if (ce != null) {
                    ce.remove();
                }
            }
        });
    }

    public InputStream open(Materializer materializer, IProgressMonitor monitor) throws IOException, CoreException {
        return this.open(materializer, monitor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream open(Materializer materializer, IProgressMonitor monitor, FileInfoBuilder fileInfo) throws IOException, CoreException {
        CacheEntry ce;
        String key = materializer.getKey();
        Object object = this;
        synchronized (object) {
            ce = (CacheEntry)this.get(key);
            if (ce == null) {
                ce = new CacheEntry();
                this.put(key, ce);
            }
        }
        object = ce;
        synchronized (object) {
            ce.initialize(this, materializer, monitor, fileInfo);
            return ce.open();
        }
    }

    @Override
    public boolean scheduleOnPut() {
        return false;
    }

    public static interface Materializer {
        public String getKey();

        public FileHandle materialize(IProgressMonitor var1, FileInfoBuilder var2) throws IOException, CoreException;
    }
}

