/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.ElementMapper;
import org.eclipse.buckminster.core.helpers.MappingException;
import org.eclipse.buckminster.core.helpers.StringUtil;
import org.eclipse.osgi.util.NLS;

public class SmartArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 5853596854483494180L;

    public static SmartArrayList<String> fromCommaSeparatedStrings(String values) throws Exception {
        return SmartArrayList.fromSeparatedStrings(values, ',');
    }

    public static SmartArrayList<String> fromSeparatedStrings(String values, char delimiter) throws Exception {
        String bareStringPattern = "(?:[^\\\\\"" + delimiter + "]|\\\\.)+";
        String doubleQuotedStringPattern = "\"(?:[^\"\\\\]|\\\\.)*\"";
        Pattern tokenPattern = Pattern.compile("^\\s*((?:" + bareStringPattern + "|" + "\"(?:[^\"\\\\]|\\\\.)*\"" + ")*)(?:\\s*" + delimiter + "(.*))?$");
        Pattern elementPattern = Pattern.compile("(" + bareStringPattern + "|" + "\"(?:[^\"\\\\]|\\\\.)*\"" + ")");
        Matcher tokenMatcher = tokenPattern.matcher(values);
        SmartArrayList<String> result = new SmartArrayList<String>();
        boolean firstMatch = false;
        while (tokenMatcher.matches()) {
            firstMatch = true;
            String value = tokenMatcher.group(1);
            StringBuilder strippedValue = new StringBuilder();
            Matcher elementMatcher = elementPattern.matcher(value);
            while (elementMatcher.find()) {
                String aux = elementMatcher.group(1);
                if (aux.startsWith("\"")) {
                    if (!aux.endsWith("\"")) {
                        throw new Exception(NLS.bind((String)Messages.Unbalanced_double_quotes_0, (Object)values));
                    }
                    aux = aux.substring(1, aux.length() - 1);
                }
                strippedValue.append(aux);
            }
            result.add(StringUtil.stripBackslashes(strippedValue.toString()));
            String rest = tokenMatcher.group(2);
            if (rest == null) break;
            tokenMatcher = tokenPattern.matcher(tokenMatcher.group(2));
        }
        if (!firstMatch) {
            throw new Exception(NLS.bind((String)Messages.Bad_value_list_0, (Object)values));
        }
        return result;
    }

    public SmartArrayList() {
    }

    public SmartArrayList(Collection<? extends E> c) {
        super(c);
    }

    public <S> SmartArrayList(Collection<? extends S> c, ElementMapper<S, E> m) throws MappingException {
        super(c.size());
        for (S elem : c) {
            E newElem = m.mapping(elem);
            if (newElem == null) continue;
            this.add(newElem);
        }
    }

    public SmartArrayList(E ... args) {
        super(Arrays.asList(args));
    }

    public SmartArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public boolean hasEqualContent(SmartArrayList<E> otherList) {
        for (Object item : this) {
            if (otherList.contains(item)) continue;
            return false;
        }
        for (Object item : otherList) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public SmartArrayList<E> reverse() {
        Collections.reverse(this);
        return this;
    }

    public SmartArrayList<E> rotate(int distance) {
        Collections.rotate(this, distance);
        return this;
    }

    public SmartArrayList<E> shuffle() {
        Collections.shuffle(this);
        return this;
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    public String toString(String delimiter) {
        Object[] arr = this.toArray();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < arr.length) {
            result.append(String.valueOf(i > 0 ? delimiter : "") + arr[i]);
            ++i;
        }
        return result.toString();
    }
}

