/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class TimedHashMap<K, V>
implements Map<K, V> {
    private static final Timer timer = new Timer();
    private final long keepAliveTime;
    private final EvictionPolicy<K, V> evictionPolicy;
    private final HashMap<K, TimedEntry> map = new HashMap();

    public TimedHashMap(long keepAliveTime, EvictionPolicy<K, V> evictionPolicy) {
        this.keepAliveTime = keepAliveTime;
        this.evictionPolicy = evictionPolicy;
    }

    public void cancel(K key) {
        TimedEntry entry = this.map.get(key);
        if (entry != null) {
            entry.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        HashMap<K, TimedEntry> hashMap = this.map;
        synchronized (hashMap) {
            for (TimedEntry entry : this.map.values()) {
                entry.remove();
            }
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        HashMap<K, TimedEntry> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsValue(Object value) {
        HashMap<K, TimedEntry> hashMap = this.map;
        synchronized (hashMap) {
            Iterator<TimedEntry> iterator = this.map.values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return false;
                }
                Map.Entry te = iterator.next();
                Object tv = te.getValue();
                if (value == null) {
                    if (tv != null) continue;
                    return true;
                }
                if (value.equals(tv)) break;
            }
            return true;
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final Iterator<TimedEntry> entries = this.map.values().iterator();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return entries.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return (Map.Entry)entries.next();
                    }

                    @Override
                    public void remove() {
                        entries.remove();
                    }
                };
            }

            @Override
            public int size() {
                return TimedHashMap.this.map.size();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        HashMap<K, TimedEntry> hashMap = this.map;
        synchronized (hashMap) {
            Map.Entry te = this.map.get(key);
            return te == null ? null : (V)te.getValue();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        V oldVal;
        TimedEntry entry = new TimedEntry(key, value);
        HashMap<K, TimedEntry> hashMap = this.map;
        synchronized (hashMap) {
            TimedEntry oldEntry = this.map.get(key);
            if (oldEntry != null) {
                oldVal = oldEntry.getValue();
                oldEntry.remove();
            } else {
                oldVal = null;
            }
            this.map.put(key, entry);
        }
        if (this.scheduleOnPut()) {
            timer.schedule((TimerTask)entry, this.keepAliveTime);
        }
        return oldVal;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        HashMap<K, TimedEntry> hashMap = this.map;
        synchronized (hashMap) {
            TimedEntry te;
            block4: {
                te = this.map.remove(key);
                if (te != null) break block4;
                return null;
            }
            Object oldVal = te.getValue();
            te.remove();
            return oldVal;
        }
    }

    public void schedule(K key) {
        TimedEntry entry = this.map.get(key);
        if (entry != null) {
            timer.schedule((TimerTask)entry, this.keepAliveTime);
        }
    }

    public boolean scheduleOnPut() {
        return true;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        final Iterator<TimedEntry> entries = this.map.values().iterator();
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return entries.hasNext();
                    }

                    @Override
                    public V next() {
                        return ((TimedEntry)entries.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        entries.remove();
                    }
                };
            }

            @Override
            public int size() {
                return TimedHashMap.this.map.size();
            }
        };
    }

    public static interface EvictionPolicy<EK, EV> {
        public void evict(Map.Entry<EK, EV> var1);
    }

    final class TimedEntry
    extends TimerTask
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        TimedEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TimedEntry val = null;
            HashMap hashMap = TimedHashMap.this.map;
            synchronized (hashMap) {
                val = (TimedEntry)TimedHashMap.this.map.remove(this.key);
            }
            if (val != null && TimedHashMap.this.evictionPolicy != null) {
                TimedHashMap.this.evictionPolicy.evict(val);
            }
        }

        @Override
        public V setValue(V value) {
            Object old = value;
            this.remove();
            this.value = value;
            timer.schedule((TimerTask)this, TimedHashMap.this.keepAliveTime);
            return old;
        }

        void remove() {
            this.cancel();
            if (TimedHashMap.this.evictionPolicy != null) {
                TimedHashMap.this.evictionPolicy.evict(this);
            }
        }
    }
}

