/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.actor;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.cspec.WellknownActions;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractBuildIntegrationActor
extends AbstractActor {
    public static final String PROPERTY_IGNORE_PROBLEMS = "buckminster.problems.ignore";
    public static final String PROPERTY_EXCLUDE_BUILDERS = "buckminster.builders.exclude";
    public static final String PROPERTY_INCLUDE_BUILDERS = "buckminster.builders.include";

    private static void build(IProject project, int buildKind, ICommand[] buildSpec, IProgressMonitor buildMonitor) throws CoreException {
        if (buildSpec == null) {
            project.build(buildKind, buildMonitor);
        } else {
            buildMonitor.beginTask(NLS.bind((String)Messages.Building_0, (Object)project.getName()), buildSpec.length);
            ICommand[] iCommandArray = buildSpec;
            int n = buildSpec.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand buildCommand = iCommandArray[n2];
                IProgressMonitor commandMonitor = MonitorUtils.subMonitor((IProgressMonitor)buildMonitor, (int)1);
                project.build(buildKind, buildCommand.getBuilderName(), buildCommand.getArguments(), commandMonitor);
                commandMonitor.done();
                ++n2;
            }
            buildMonitor.done();
        }
    }

    private static ICommand[] filterBuildSpec(IProject project, Pattern[] includeBuilders, Pattern[] skipBuilders) throws CoreException {
        if (includeBuilders == null && skipBuilders == null) {
            return null;
        }
        ICommand[] buildSpec = project.getDescription().getBuildSpec();
        int skipped = 0;
        int i = 0;
        while (i < buildSpec.length) {
            ICommand buildCommand = buildSpec[i];
            String builderName = buildCommand.getBuilderName();
            if (includeBuilders != null && !AbstractBuildIntegrationActor.matches(builderName, includeBuilders) || skipBuilders != null && AbstractBuildIntegrationActor.matches(builderName, skipBuilders)) {
                ++skipped;
            } else if (skipped != 0) {
                buildSpec[i - skipped] = buildCommand;
            }
            ++i;
        }
        if (skipped != 0) {
            ICommand[] filteredSpec = new ICommand[buildSpec.length - skipped];
            System.arraycopy(buildSpec, 0, filteredSpec, 0, filteredSpec.length);
            return filteredSpec;
        }
        return null;
    }

    private static Pattern[] getFilterPatterns(IActionContext ctx, String key) {
        String filterSpecification = (String)ctx.getProperties().get(key);
        if (filterSpecification == null) {
            return null;
        }
        String[] filterStrings = filterSpecification.split(",");
        Pattern[] filterPatterns = new Pattern[filterStrings.length];
        int i = 0;
        while (i < filterStrings.length) {
            Pattern pattern;
            String filter = filterStrings[i].trim();
            filterPatterns[i] = pattern = Pattern.compile(filter);
            ++i;
        }
        return filterPatterns;
    }

    private static boolean isMarkerIgnored(IMarker problem, Pattern[] ignoreMarkerPatterns, Set<String> ignoreMarkerCache) throws CoreException {
        if (ignoreMarkerPatterns == null) {
            return false;
        }
        String markerType = problem.getType();
        if (ignoreMarkerCache == null) {
            return AbstractBuildIntegrationActor.matches(markerType, ignoreMarkerPatterns);
        }
        if (ignoreMarkerCache.contains(markerType)) {
            return true;
        }
        if (AbstractBuildIntegrationActor.matches(markerType, ignoreMarkerPatterns)) {
            ignoreMarkerCache.add(markerType);
            return true;
        }
        return false;
    }

    private static boolean matches(String name, Pattern[] filterPatterns) {
        Pattern[] patternArray = filterPatterns;
        int n = filterPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            if (pattern.matcher(name).matches()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected String getNameForKind(IActionContext ctx) {
        return ctx.getAction().getName();
    }

    @Override
    protected IStatus internalPerform(IActionContext ctx, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 300);
        try {
            IProject project = WorkspaceInfo.getProject(ctx.getCSpec().getComponentIdentifier());
            if (project == null) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            project.refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            ICommand[] buildSpec = AbstractBuildIntegrationActor.filterBuildSpec(project, AbstractBuildIntegrationActor.getFilterPatterns(ctx, PROPERTY_INCLUDE_BUILDERS), AbstractBuildIntegrationActor.getFilterPatterns(ctx, PROPERTY_EXCLUDE_BUILDERS));
            AbstractBuildIntegrationActor.build(project, WellknownActions.ECLIPSE.name2Kind(this.getNameForKind(ctx)), buildSpec, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)200));
            Pattern[] ignoreMarkerPatterns = AbstractBuildIntegrationActor.getFilterPatterns(ctx, PROPERTY_IGNORE_PROBLEMS);
            HashSet<String> ignoreMarkerCache = ignoreMarkerPatterns == null ? null : new HashSet<String>();
            IMarker[] iMarkerArray = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker problem = iMarkerArray[n2];
                switch (problem.getAttribute("severity", 0)) {
                    case 2: {
                        if (AbstractBuildIntegrationActor.isMarkerIgnored(problem, ignoreMarkerPatterns, ignoreMarkerCache)) break;
                        throw new CoreException((IStatus)new Status(4, CorePlugin.getID(), 0, problem.getAttribute("message", ""), null));
                    }
                    case 1: {
                        if (AbstractBuildIntegrationActor.isMarkerIgnored(problem, ignoreMarkerPatterns, ignoreMarkerCache)) break;
                        Status status = new Status(2, CorePlugin.getID(), 0, problem.getAttribute("message", ""), null);
                        return status;
                    }
                }
                ++n2;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }
}

